/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.util;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilToolset;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Component;
import java.awt.Rectangle;

public class CUtilSize {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilSize.class);

    private CUtilSize() {
    }

    public static int calcWidth(CWidget aReferenceWidget, String aSize) {
        return CUtilSize.calc(aReferenceWidget, aSize, true);
    }

    private static int calc(CWidget aWidget, String aSize, boolean aWidth) {
        int size = 10;
        char c = aSize.trim().charAt(0);
        switch (c) {
            case 'R': 
            case 'r': {
                if (aWidget == null) break;
                String s2 = aSize.substring(1);
                int percent = CUtilInteger.fromString((String)s2, (int)50);
                CWidget root = aWidget.getRoot();
                if (root == null) {
                    LOG.error("Widget {} has no root", new Object[]{aWidget.getId()});
                    break;
                }
                Component component = root.getComponent();
                int refValue = aWidth ? component.getWidth() : component.getHeight();
                size = percent * refValue / 100;
                break;
            }
            case '%': 
            case 'P': 
            case 'p': {
                if (aWidget == null) break;
                String s2 = aSize.substring(1);
                int percent = CUtilInteger.fromString((String)s2, (int)50);
                CWidget parent = aWidget.getParent();
                if (parent == null) {
                    LOG.error("Widget {} has no parent", new Object[]{aWidget.getId()});
                    break;
                }
                Component component = parent.getComponent();
                int refValue = aWidth ? component.getWidth() : component.getHeight();
                size = percent * refValue / 100;
                break;
            }
            case 'S': 
            case 's': {
                if (aWidget == null) break;
                Component component = aWidget.getComponent();
                String s2 = aSize.substring(1);
                int percent = CUtilInteger.fromString((String)s2, (int)50);
                Rectangle rect = CUtilToolset.getEffectiveScreenSize(component);
                if (rect == null) break;
                int refValue = aWidth ? rect.width : rect.height;
                size = percent * refValue / 100;
                break;
            }
            default: {
                size = CUtilInteger.fromString((String)aSize);
            }
        }
        return size;
    }
}

