/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreAddLocalFile;
import de.sillysky.nyssr.impl.software.updater.local.CDownloadRequest;
import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.hash.CMd5;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CJobFindMatchingOldFiles
implements ISerialJobQueueEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobFindMatchingOldFiles.class);
    private final CSerialJobMachine mParent;
    private final ITarget mTarget;
    private final String mDir;
    private final Path mSourcePath;
    private final Path mDestinationPath;
    private final Map<String, String> mOldFileHashes = new HashMap<String, String>();
    private final Map<String, CDownloadRequest> mDownloadRequests;

    CJobFindMatchingOldFiles(@NotNull CSerialJobMachine aParent, @NotNull ITarget aTarget, @NotNull String aDir, @NotNull Path aSourcePath, @NotNull Path aDestinationPath, @NotNull Map<String, CDownloadRequest> aFiles) {
        this.mParent = aParent;
        this.mTarget = aTarget;
        this.mDir = aDir;
        this.mSourcePath = aSourcePath;
        this.mDestinationPath = aDestinationPath;
        this.mDownloadRequests = aFiles;
    }

    @NotNull
    public String getId() {
        return "FindMatchingOldFiles" + this.mDir;
    }

    public void stop() {
    }

    public void start() throws Exception {
        this.createOrClearDirectory(this.mDestinationPath);
        this.findMatchingOldFiles(this.mDir, this.mSourcePath, this.mDestinationPath);
        this.mParent.jobFinished(this);
    }

    private void createOrClearDirectory(@NotNull Path aDir) throws CException {
        File dir = aDir.toFile();
        if (dir.exists()) {
            CUtilFile.removeAllFilesInDirectory((File)dir);
        } else {
            CUtilFile.createDirectoriesEx((File)dir);
        }
    }

    private void findMatchingOldFiles(@NotNull String aRelativePath, @NotNull Path aOldDir, @NotNull Path aNewDir) throws CException {
        try {
            Stream<Path> list = Files.list(aOldDir);
            list.forEach(sourceFile -> this.processFileInOldDir((Path)sourceFile, aRelativePath, aNewDir));
        }
        catch (IOException aException) {
            throw new CException((Throwable)aException);
        }
    }

    private void processFileInOldDir(@NotNull Path aSourceFile, @NotNull String aRelativePath, @NotNull Path aNewDir) {
        CDownloadRequest request = this.fileMatchRequest(aSourceFile);
        if (request == null) {
            try {
                this.addFileToFileStore(aRelativePath, aSourceFile);
            }
            catch (CException aException) {
                LOG.error("Couldn't add file to FileStore: {}: {}", new Object[]{aSourceFile, aException.getMessage()});
            }
        } else {
            try {
                Path fileName = aSourceFile.getFileName();
                Path newFile = aNewDir.resolve(fileName);
                Files.copy(aSourceFile, newFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                request.setFile(newFile.toFile());
            }
            catch (IOException aException) {
                LOG.error("Couldn't copy file {} to {}: {}", new Object[]{aSourceFile, aNewDir, aException.getMessage()});
            }
        }
    }

    private CDownloadRequest fileMatchRequest(@NotNull Path aOldFile) {
        for (CDownloadRequest request : this.mDownloadRequests.values()) {
            String oldFilename;
            String requestedFilename = request.getFilename();
            if (!requestedFilename.equals(oldFilename = aOldFile.getFileName().toString())) continue;
            String requestHash = request.getHash();
            if (CUtilString.isValid((String)requestHash)) {
                String oldHash = this.getOldFileHash(aOldFile.toFile());
                if (!requestHash.equals(oldHash)) continue;
                return request;
            }
            return request;
        }
        return null;
    }

    private void addFileToFileStore(@NotNull String aRelativeDestDir, @NotNull Path aSourceFile) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordFileStoreAddLocalFile.class);
        CRecord record = CRecordFileStoreAddLocalFile.create();
        CRecordFileStoreAddLocalFile.setPath((CRecord)record, (String)aSourceFile.toString());
        CRecordFileStoreAddLocalFile.setRelativeDestinationPath((CRecord)record, (String)aRelativeDestDir);
        this.mTarget.sendNotification(env, record);
    }

    @Nullable
    private String getOldFileHash(@NotNull File aFile) {
        CMd5 md5;
        String name = aFile.getName();
        String hash = this.mOldFileHashes.get(name);
        if (hash == null && (md5 = CUtilMd5.calculate((File)aFile, null)) != null) {
            hash = md5.toBase32();
            this.mOldFileHashes.put(name, hash);
        }
        return hash;
    }
}

