/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonStringList;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventShowMessageDialog
implements IRemoteSkinEvent {
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String BUTTONS = "buttons";
    public static final String DEFAULT_BUTTON = "defaultButton";
    public static final String ICON = "icon";
    public static final String RESULT = "result";
    public static final String THE_DEFAULT_BUTTON = "Okay";
    public static final String[] THE_DEFAULT_BUTTONS = new String[]{"Okay"};
    public static final String THE_DEFAULT_TITLE = "Message";
    private final String mText;
    private String[] mButtons;
    private String mDefaultButton;
    private String mTitle;
    private CEventIcon mIcon;

    public CEventShowMessageDialog(@NotNull String aText) {
        this.mText = aText;
        this.mTitle = null;
        this.mButtons = null;
        this.mDefaultButton = null;
        this.mIcon = null;
    }

    @Nullable
    public static CEventShowMessageDialog create(@Nullable Object aValue) {
        CJsonObject jo;
        String text;
        if (aValue instanceof CJsonObject && CUtilString.isValid((String)(text = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)TEXT, (String)"?")))) {
            CEventShowMessageDialog event = new CEventShowMessageDialog(text);
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)TITLE, (String)THE_DEFAULT_TITLE);
            event.setTitle(title);
            String[] buttons = THE_DEFAULT_BUTTONS;
            Object o = jo.getValue(BUTTONS);
            if (o != null) {
                List buttonList = CUtilJsonStringList.fromJson((Object)o);
                buttons = buttonList.toArray(new String[0]);
                event.setButtons(buttons);
            }
            String defaultButton = CUtilJsonString.fromJson((CJsonObject)jo, (String)DEFAULT_BUTTON, (String)(buttons.length > 0 ? buttons[0] : THE_DEFAULT_BUTTON));
            event.setDefaultButton(defaultButton);
            CEventIcon icon = CEventIcon.fromObject(jo.getValue(ICON));
            event.setIcon(icon);
            return event;
        }
        return null;
    }

    @Nullable
    public CEventIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(CEventIcon aIcon) {
        this.mIcon = aIcon;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(@NotNull String aTitle) {
        this.mTitle = aTitle;
    }

    @NotNull
    public String getText() {
        return this.mText;
    }

    @NotNull
    public String getDefaultButton() {
        return this.mDefaultButton == null ? THE_DEFAULT_BUTTON : this.mDefaultButton;
    }

    public void setDefaultButton(String aDefaultButton) {
        this.mDefaultButton = aDefaultButton;
    }

    public String[] getButtons() {
        return this.mButtons == null ? THE_DEFAULT_BUTTONS : this.mButtons;
    }

    public void setButtons(String[] aButtons) {
        this.mButtons = aButtons;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(TITLE, (Object)this.mTitle);
        jo.put(TEXT, (Object)this.mText);
        CJsonArray arr = new CJsonArray();
        for (String s : this.mButtons) {
            arr.add((Object)s);
        }
        jo.put(BUTTONS, (Object)arr);
        jo.put(DEFAULT_BUTTON, (Object)this.mDefaultButton);
        if (this.mIcon != null) {
            jo.put(ICON, this.mIcon.toJson());
        }
        return jo;
    }
}

