/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EIconUsage;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.string.CUtilBase64;
import de.sillysky.nyssr.util.swing.icon.CIconHelper;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventIcon
implements IRemoteSkinEvent {
    public static final int INVALID = Integer.MIN_VALUE;
    private static final String BYTES = "bytes";
    private static final String PATH = "path";
    private static final String CLIENT_ICON_NAME = "client";
    private static final String DESCRIPTION = "desc";
    private static final String USAGE = "usage";
    private static final String X = "x";
    private static final String Y = "y";
    private byte[] mBytes = null;
    private String mPath = null;
    private String mClientIconName = null;
    private String mDescription = null;
    private EIconUsage mUsage = null;
    private int mX = -1;
    private int mY = -1;

    @Nullable
    public static CEventIcon fromResource(@NotNull Class<?> aClass, @NotNull String aResourcePath, @Nullable String aDescription) {
        byte[] bb = CIconHelper.loadBytesFromJar(aClass, (String)aResourcePath);
        if (bb != null) {
            CEventIcon icon = new CEventIcon();
            icon.setBytes(bb);
            if (CUtilString.isValid((String)aDescription)) {
                icon.setDescription(aDescription);
            }
            return icon;
        }
        return null;
    }

    @Nullable
    public static CEventIcon fromObject(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            Object o;
            CJsonObject jo = (CJsonObject)aValue;
            CEventIcon event = new CEventIcon();
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)BYTES, null);
            if (s != null) {
                byte[] bytes = CUtilBase64.decode((String)s);
                event.setBytes(bytes);
            }
            if ((s = CUtilJsonString.fromJson((CJsonObject)jo, (String)PATH, null)) != null) {
                event.setPath(s);
            }
            if ((s = CUtilJsonString.fromJson((CJsonObject)jo, (String)CLIENT_ICON_NAME, null)) != null) {
                event.setClientIconName(s);
            }
            if ((o = jo.getValue(DESCRIPTION)) instanceof String) {
                event.setDescription((String)o);
            }
            if ((o = jo.getValue(USAGE)) instanceof String) {
                EIconUsage usage = (EIconUsage)((Object)CUtilEnum.fromString(EIconUsage.class, (String)((String)o), (Object)((Object)EIconUsage.enabled)));
                event.setUsage(usage);
            }
            o = jo.getValue(X);
            int x = CUtilInteger.fromObject((Object)o, (int)Integer.MIN_VALUE);
            event.setX(x);
            o = jo.getValue(Y);
            int y = CUtilInteger.fromObject((Object)o, (int)Integer.MIN_VALUE);
            event.setY(y);
            return event;
        }
        if (aValue instanceof String) {
            CEventIcon event = new CEventIcon();
            event.setClientIconName((String)aValue);
            return event;
        }
        return null;
    }

    public String getClientIconName() {
        return this.mClientIconName;
    }

    public void setClientIconName(String aClientIconName) {
        this.mClientIconName = aClientIconName;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public void setBytes(byte[] aBytes) {
        this.mBytes = aBytes;
    }

    @Nullable
    public ImageIcon createIcon(@Nullable Class<?> aClass) {
        byte[] bytes = this.mBytes;
        if (bytes == null && aClass != null && CUtilString.isValid((String)this.mClientIconName)) {
            bytes = CIconHelper.loadBytesFromJar(aClass, (String)("/images/" + this.mClientIconName));
        }
        if (bytes != null) {
            String desc = this.mDescription == null ? "" : this.mDescription;
            return new ImageIcon(bytes, desc);
        }
        return null;
    }

    @Nullable
    public String getPath() {
        return this.mPath;
    }

    public void setPath(String aPath) {
        this.mPath = aPath;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    @Nullable
    public EIconUsage getUsage() {
        return this.mUsage;
    }

    public void setUsage(@NotNull EIconUsage aUsage) {
        this.mUsage = aUsage;
    }

    public int getX() {
        return this.mX;
    }

    public void setX(int aX) {
        this.mX = aX;
    }

    public int getY() {
        return this.mY;
    }

    public void setY(int aY) {
        this.mY = aY;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject();
        if (this.mBytes != null) {
            String s = CUtilBase64.encodeToString((byte[])this.mBytes);
            jo.put(BYTES, (Object)s);
        }
        if (CUtilString.isValid((String)this.mPath)) {
            jo.put(PATH, (Object)this.mPath);
        }
        if (CUtilString.isValid((String)this.mDescription)) {
            jo.put(DESCRIPTION, (Object)this.mDescription);
        }
        if (this.mUsage != null) {
            jo.put(USAGE, (Object)this.mUsage.name());
        }
        if (this.mX != Integer.MIN_VALUE) {
            jo.put(X, (Object)this.mX);
        }
        if (this.mY != Integer.MIN_VALUE) {
            jo.put(Y, (Object)this.mY);
        }
        return jo;
    }
}

