/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.combobox;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.combobox.CComboBoxModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxEditorNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventUpdateComboBox;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxEditListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import org.jetbrains.annotations.NotNull;

public class CComboBoxUi {
    private final CComboBoxModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs317;
    private final CWidgetId mComboBox2;
    private CWidgetId m317PanelMain;

    public CComboBoxUi(@NotNull CComboBoxModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs317 = CWidgetSetId.create((String)"@317_ComboBox", (String)instance);
        for (int i = 0; i <= 4; ++i) {
            CWidgetId ComboBox = CWidgetId.create((String)("#317_Component_" + i), (CWidgetSetId)this.mWs317);
            this.mApi.addListener(ComboBox, (IListener)((IComboBoxSelectionListener)this::onComboBoxSelect));
        }
        CWidgetId comboBox1 = CWidgetId.create((String)"#317_Component_1", (CWidgetSetId)this.mWs317);
        this.mComboBox2 = CWidgetId.create((String)"#317_Component_2", (CWidgetSetId)this.mWs317);
        CWidgetId checkBox2 = CWidgetId.create((String)"#317_Helper_2", (CWidgetSetId)this.mWs317);
        this.mApi.addListener(this.mComboBox2, (IListener)((IComboBoxEditListener)this::onComboBoxEdit));
        this.mApi.addListener(checkBox2, (IListener)((IButtonPressedListener)this::onCheckBox2));
    }

    private void onComboBoxSelect(@NotNull CEventComboBoxSelectionNotification aEvent) {
        this.mModel.getAppContext().addMessage("ComboBox entry selected: " + aEvent.getEntryId());
    }

    private void onCheckBox2(@NotNull CEventButtonPressedNotification aEvent) {
        this.mApi.setEditable(this.mComboBox2, aEvent.isSelected());
        this.mServerContext.sendUpdate();
    }

    private void onComboBoxEdit(@NotNull CEventComboBoxEditorNotification aEvent) {
        String lastSelectedId = aEvent.getLastSelectedId();
        String newText = aEvent.getNewText();
        CEventUpdateComboBox event = new CEventUpdateComboBox();
        CEventLabelItem item = new CEventLabelItem(lastSelectedId);
        item.getAttributes().setValue((Object)newText);
        event.addItem(item);
        this.mApi.updateComboBox(this.mComboBox2, event);
        this.mServerContext.sendUpdate();
    }

    private void widgetSet317Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m317PanelMain = CWidgetId.create((String)"#317_Panel_Main", (CWidgetSetId)this.mWs317);
        this.mApi.setVisible(this.m317PanelMain, true);
        this.mServerContext.sendUpdate();
        this.mModel.getAppContext().sendOtherWidgetSets();
    }

    void mountWidgetSet317() {
        this.mServerContext.mountWidgetSet(this.mWs317, this.mModel.getParent(), "#317_Panel_Main", this::widgetSet317Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m317PanelMain);
    }
}

