/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordAddAppFactory;
import de.sillysky.nyssr.app.factory.collector.records.CRecordApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordRemoveAppFactory;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.app.widget.showcase.CApp;
import de.sillysky.nyssr.impl.app.widget.showcase.CApplicationContext;
import de.sillysky.nyssr.impl.app.widget.showcase.CConstants;
import de.sillysky.nyssr.impl.app.widget.showcase.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CAppFactory
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppFactory.class);
    private final IDependencies mDependencies;

    CAppFactory(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAddAppFactory.ID, this::asyncAddAppFactory);
        this.addMessageHandler(CRecordLaunchApplication.ID, this::asyncRunApplication);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.APP_FACTORY, "ApplicationFactory");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterApplicationFactory();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.registerApplicationFactory();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddAppFactory(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                LOG.debug("AppFactory {} successfully registered", new Object[]{"WidgetShowcase"});
            } else {
                LOG.error("Error on registering AppFactory {}: {},{}", new Object[]{"WidgetShowcase", resultCode, aEnvelope.getResultText()});
            }
            return true;
        }
        return false;
    }

    private boolean asyncRunApplication(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID applicationId = CRecordLaunchApplication.getApplicationId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)applicationId, (String)"Missing application id", (Object[])new Object[0]);
        CUtilCheck.checkEqual((Object)applicationId, (Object)CConstants.APP_ID, (String)("Unsupported application id: " + applicationId), (Object[])new Object[0]);
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNullEx((Object)sessionToken, (String)"Missing session token", (Object[])new Object[0]);
        CStringProperties properties = CRecordLaunchApplication.getProperties((CRecord)aRecord, null);
        if (properties == null) {
            properties = new CStringProperties();
        }
        CNodeAddress remoteSkinClient = CRecordLaunchApplication.getRemoteSkinClientNode((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)remoteSkinClient, (String)"Missing RemoteSkin client address", (Object[])new Object[0]);
        UUID instanceId = CUtilUuid.random();
        IId nid = CIdFactory.random((String)"AppUserManager");
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "AppUserManager");
        CApplicationContext context = new CApplicationContext(sessionToken, properties, ns, instanceId, remoteSkinClient);
        this.start(context);
        aEnvelope.setResultSuccess();
        return true;
    }

    private void start(@NotNull CApplicationContext aContext) throws Exception {
        CApp app = new CApp();
        app.activate(this.mDependencies, aContext);
    }

    private void registerApplicationFactory() throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        CRecord record = CRecordAddAppFactory.create();
        CRecordAddAppFactory.setApplication((CRecord)record, (CRecord)this.createApplicationRecord());
        CRecordAddAppFactory.setFactoryAddress((CRecord)record, (CTargetAddress)this.getAddress());
        this.sendRequest(env, record);
    }

    private void deregisterApplicationFactory() throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        CRecord record = CRecordRemoveAppFactory.create();
        CRecordRemoveAppFactory.setFactoryAddress((CRecord)record, (CTargetAddress)this.getAddress());
        CRecordRemoveAppFactory.setApplicationId((CRecord)record, (UUID)CConstants.APP_ID);
        this.sendRequest(env, record);
    }

    @NotNull
    private CRecord createApplicationRecord() throws CException {
        CRecord record = CRecordApplication.create();
        CRecordApplication.setId((CRecord)record, (UUID)CConstants.APP_ID);
        CRecordApplication.setName((CRecord)record, (String)"WidgetShowcase");
        CRecordApplication.setShortDescription((CRecord)record, (String)"Show some Swing Widgets");
        CRecordApplication.setLongDescription((CRecord)record, (String)"Show some Swing Widgets");
        CRecordApplication.setPlatform((CRecord)record, (String)"swing");
        CRecordApplication.setIcon((CRecord)record, (String)"apps/WidgetShowcase/WidgetShowcase.png");
        CRecordApplication.setPermissions((CRecord)record, (String[])CConstants.PERMISSIONS_NEEDED);
        return record;
    }
}

