/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.impl.network.router.CRouter;
import de.sillysky.nyssr.impl.network.router.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.network.client.handling.IClientHandlingService;
import de.sillysky.nyssr.network.hints.IRoutingHintRegistry;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageImplNetworkRouter
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IKernelConfiguration mKernelConfiguration;
    private IMessageSender mMessageSender;
    private INodeInfoDatabase mNodeInfoDatabase;
    private IRoutingHintRegistry mRoutingHintRegistry;
    private IClientHandlingService mClientHandlingService;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(INodeInfoDatabase.class);
        aDependencyList.add(IRoutingHintRegistry.class);
        aDependencyList.add(IClientHandlingService.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mMessageSender = (IMessageSender)aServiceRegistry.getServiceOrThrow(IMessageSender.class);
            this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
            this.mRoutingHintRegistry = (IRoutingHintRegistry)aServiceRegistry.getServiceOrThrow(IRoutingHintRegistry.class);
            this.mClientHandlingService = (IClientHandlingService)aServiceRegistry.getServiceOrThrow(IClientHandlingService.class);
            this.mService = new CRouter(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }

    @Override
    public INodeInfoDatabase getNodeInfoDatabase() {
        return this.mNodeInfoDatabase;
    }

    @Override
    public IRoutingHintRegistry getRoutingHintRegistry() {
        return this.mRoutingHintRegistry;
    }

    @Override
    public IClientHandlingService getClientHandlingService() {
        return this.mClientHandlingService;
    }
}

