/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.router.CDijkstraLinkList;
import de.sillysky.nyssr.impl.network.router.CDijkstraNeighbor;
import de.sillysky.nyssr.impl.network.router.CDijkstraNode;
import de.sillysky.nyssr.impl.network.router.CDijkstraNodeList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CDijkstraAlgorithm {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDijkstraAlgorithm.class);
    private final CNodeAddress mLocalNodeId;
    private CDijkstraLinkList mLinks;
    private CDijkstraNodeList mNodes;

    CDijkstraAlgorithm(CNodeAddress aLocalNodeId, CDijkstraLinkList aLinks) {
        this.mLocalNodeId = aLocalNodeId;
        this.mLinks = new CDijkstraLinkList(this.mLocalNodeId, aLinks);
        this.mNodes = this.mLinks.getNodes();
    }

    void execute(CNodeAddress aSource) {
        if (!this.mLinks.isEmpty()) {
            this.mNodes = this.mLinks.getNodes();
            CDijkstraNode sourceNode = this.mNodes.get(aSource);
            if (sourceNode == null) {
                LOG.error("Error in calculation of Dijkstra Path: SourceNode not found: {}", new Object[]{aSource});
                this.mLinks.dump(null);
                return;
            }
            sourceNode.setTotalCosts(0);
            sourceNode.unSettle();
            while (this.mNodes.getUnsettledCount() > 0) {
                CDijkstraNode node = this.mNodes.findUnsettledNodeWithMinimumCosts();
                node.settle();
                this.findMinimalCosts(node);
            }
        }
    }

    private void findMinimalCosts(@NotNull CDijkstraNode aNode) {
        int myTotalCosts = aNode.getTotalCosts();
        Collection<CDijkstraNeighbor> neighbors = this.mLinks.getNeighbors(aNode.getNodeId());
        for (CDijkstraNeighbor neighbor : neighbors) {
            int neighborTotalCosts;
            int costs;
            int neighborNewTotalCosts;
            CNodeAddress neighborNodeId = neighbor.getNodeAddress();
            CDijkstraNode neighborNode = this.mNodes.get(neighborNodeId);
            if (neighborNode.isSettled() || (neighborNewTotalCosts = myTotalCosts + (costs = neighbor.getCosts())) >= (neighborTotalCosts = neighborNode.getTotalCosts())) continue;
            neighborNode.setTotalCosts(neighborNewTotalCosts);
            neighborNode.setPrevious(aNode.getNodeId());
            neighborNode.unSettle();
        }
    }

    @Nullable
    Collection<CDijkstraLink> getLinkPath(CNodeAddress aDestinationNodeId) {
        LinkedList<CDijkstraLink> path = new LinkedList<CDijkstraLink>();
        if (this.mNodes.isEmpty()) {
            return null;
        }
        CNodeAddress toId = aDestinationNodeId;
        while (toId != null) {
            CDijkstraNode to = this.mNodes.get(toId);
            if (to == null) {
                return null;
            }
            CNodeAddress fromId = to.getPrevious();
            if (fromId != null) {
                CDijkstraLink link = this.mLinks.find(fromId, toId);
                path.add(link);
            }
            toId = fromId;
        }
        return path;
    }

    @Nullable
    CNodeAddress getNextNode(@Nullable CNodeAddress aDestination) {
        CDijkstraNode node;
        CNodeAddress to = aDestination;
        while (to != null && (node = this.mNodes.get(to)) != null) {
            CNodeAddress from = node.getPrevious();
            if (this.mLocalNodeId.equals((Object)from)) {
                return to;
            }
            to = from;
        }
        return null;
    }

    @NotNull
    LinkedList<CNodeAddress> getPath(CNodeAddress aDestinationNodeId) {
        return this.mNodes.getPath(aDestinationNodeId);
    }

    @NotNull
    Collection<CNodeAddress> getReachableNodes() {
        return this.mNodes.getReachableNodeIds();
    }

    @NotNull
    Collection<CNodeAddress> getUnreachableNodes() {
        return this.mNodes.getUnreachableNodeIds();
    }

    boolean isReachable(CNodeAddress aDestination) {
        CNodeAddress nodeId = this.getNextNode(aDestination);
        return nodeId != null;
    }

    void update(CDijkstraLinkList aLinks) {
        this.mLinks = new CDijkstraLinkList(this.mLocalNodeId, aLinks);
        this.mNodes = this.mLinks.getNodes();
        this.execute(this.mLocalNodeId);
        aLinks.removeUnreachableLinks(this.mNodes);
    }
}

