/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.jsonmessage;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.CPacketJsonMessage;
import de.sillysky.nyssr.impl.network.packet.factory.jsonmessage.IDependencies;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class CPacketFactoryJsonMessage
implements IPacketFactory,
IService {
    @NotNull
    private final IDependencies mDependencies;
    private CStreamHeaderFactoryRegistry<CPacketMessage> mHeaderFactoryRegistry;
    private int mRunningNo = 0;

    CPacketFactoryJsonMessage(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mDependencies.getPacketFactoryRegistry().registerPacketFactory(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mDependencies.getPacketFactoryRegistry().deregisterPacketFactory(this);
    }

    @Override
    @NotNull
    public IPacket fromObject(@NotNull Object aObject) {
        ++this.mRunningNo;
        if (this.mRunningNo < 0) {
            this.mRunningNo = 0;
        }
        return new CPacketJsonMessage(this.mDependencies, (CMessage)aObject, this.mRunningNo);
    }

    @Override
    @NotNull
    public IPacket fromStream(@NotNull DataInput aStream, boolean aIsTest) throws IOException {
        int size = aStream.readInt();
        byte[] bytes = new byte[size];
        aStream.readFully(bytes);
        return new CPacketJsonMessage(this.mDependencies, bytes);
    }

    @Override
    public EPacketType getType() {
        return EPacketType.JSON_MESSAGE;
    }
}

