/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.consumer.registry;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketConsumerRegistry;
import de.sillysky.nyssr.network.packets.IPacketContext;
import de.sillysky.nyssr.network.packets.IPacketTypeConsumer;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class CPacketConsumerRegistry
implements IPacketConsumerRegistry,
IService {
    private final Map<EPacketType, IPacketTypeConsumer> mConsumers = new ConcurrentHashMap<EPacketType, IPacketTypeConsumer>();

    CPacketConsumerRegistry() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IPacketConsumerRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deregisterPacketConsumer(@NotNull IPacketTypeConsumer aConsumer) {
        EPacketType type = aConsumer.getType();
        this.mConsumers.remove((Object)type);
    }

    @Override
    public void registerPacketConsumer(@NotNull IPacketTypeConsumer aConsumer) {
        EPacketType type = aConsumer.getType();
        this.mConsumers.putIfAbsent(type, aConsumer);
    }

    @Override
    public void consume(@NotNull IPacketContext aContext, @NotNull IPacket aPacket) throws CException {
        EPacketType type = aPacket.getType();
        IPacketTypeConsumer consumer = this.mConsumers.get((Object)type);
        if (consumer == null) {
            throw new CException(3).append("Unknown type ").append((Object)type);
        }
        consumer.consumePacket(aContext, aPacket);
    }
}

