/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.costs;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.costs.CCostEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordAddLinkCosts;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CCostList {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private final Map<UUID, CCostEntry> mCosts = new HashMap<UUID, CCostEntry>();

    CCostList() {
    }

    void add(@NotNull UUID aConnectionId, int aCosts) {
        CCostEntry entry = this.mCosts.get(aConnectionId);
        if (entry == null) {
            entry = new CCostEntry(aConnectionId);
            this.mCosts.put(aConnectionId, entry);
        }
        entry.addCosts(aCosts);
    }

    void remove(@NotNull UUID aConnectionId) {
        this.mCosts.remove(aConnectionId);
    }

    @Nullable
    CRecord toRecord() throws CException {
        int size = this.mCosts.size();
        if (size > 0) {
            UUID[] connectionIds = new UUID[size];
            int[] costs = new int[size];
            int i = 0;
            for (CCostEntry entry : this.mCosts.values()) {
                connectionIds[i] = entry.getConnectionId();
                costs[i] = entry.getAverage();
                entry.reset();
                ++i;
            }
            CRecord record = CRecordAddLinkCosts.create();
            CRecordAddLinkCosts.setConnectionIds((CRecord)record, (UUID[])connectionIds);
            CRecordAddLinkCosts.setCosts((CRecord)record, (int[])costs);
            return record;
        }
        return null;
    }
}

