/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.helper;

import de.sillysky.nyssr.impl.microservice.helper.CHelperForLocalMicroServices;
import de.sillysky.nyssr.impl.microservice.helper.IDependencies;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.network.broadcast.IBroadcastService;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplMicroServiceHelper
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMicroServiceRegistryCollector.class);
        aDependencyList.add(IBroadcastService.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistryCollector.class);
            this.mService = new CHelperForLocalMicroServices(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IMicroServiceRegistryCollector getMicroServiceRegistryCollector() {
        return this.mMicroServiceRegistryCollector;
    }
}

