/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.layout;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMigLayout
implements IRemoteSkinEvent {
    private static final String LAYOUT_CONSTRAINTS = "layout";
    private static final String COLUMN_CONSTRAINTS = "column";
    private static final String ROW_CONSTRAINTS = "row";
    private static final String DEFAULT_CONSTRAINTS = "";
    private final String mLayoutConstraints;
    private final String mColumnConstraints;
    private final String mRowConstraints;

    public CEventMigLayout(@NotNull String aLayoutConstraints, @NotNull String aColumnConstraints, @NotNull String aRowConstraints) {
        this.mLayoutConstraints = aLayoutConstraints;
        this.mColumnConstraints = aColumnConstraints;
        this.mRowConstraints = aRowConstraints;
    }

    @Nullable
    public static CEventMigLayout create(@Nullable Object aValue) {
        boolean enabled;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String layout = CUtilJsonString.fromJson((CJsonObject)jo, (String)LAYOUT_CONSTRAINTS, (String)DEFAULT_CONSTRAINTS);
            String column = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_CONSTRAINTS, (String)DEFAULT_CONSTRAINTS);
            String row = CUtilJsonString.fromJson((CJsonObject)jo, (String)ROW_CONSTRAINTS, (String)DEFAULT_CONSTRAINTS);
            return new CEventMigLayout(layout, column, row);
        }
        if (aValue instanceof String) {
            return new CEventMigLayout((String)aValue, DEFAULT_CONSTRAINTS, DEFAULT_CONSTRAINTS);
        }
        if (aValue instanceof Boolean && (enabled = ((Boolean)aValue).booleanValue())) {
            return new CEventMigLayout(DEFAULT_CONSTRAINTS, DEFAULT_CONSTRAINTS, DEFAULT_CONSTRAINTS);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(LAYOUT_CONSTRAINTS, (Object)this.mLayoutConstraints);
        jo.put(COLUMN_CONSTRAINTS, (Object)this.mColumnConstraints);
        jo.put(ROW_CONSTRAINTS, (Object)this.mRowConstraints);
        return jo;
    }

    @NotNull
    public String getLayoutConstraints() {
        return this.mLayoutConstraints;
    }

    @NotNull
    public String getColumnConstraints() {
        return this.mColumnConstraints;
    }

    @NotNull
    public String getRowConstraints() {
        return this.mRowConstraints;
    }
}

