/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventSelectItems
implements IRemoteSkinEvent {
    private final Set<String> mItemIds = new HashSet<String>();

    @Nullable
    public static CEventSelectItems create(@Nullable Object aValue) {
        if (aValue instanceof CJsonArray) {
            CEventSelectItems event = new CEventSelectItems();
            CJsonArray arr = (CJsonArray)aValue;
            for (Object child : arr.getChildren()) {
                if (!(child instanceof String)) continue;
                event.addItemId((String)child);
            }
            return event;
        }
        return null;
    }

    public void addItemId(@NotNull String aItemId) {
        if (CUtilString.isValid((String)aItemId)) {
            this.mItemIds.add(aItemId);
        }
    }

    public Collection<String> getItemIds() {
        return this.mItemIds;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray arr = new CJsonArray();
        for (String itemId : this.mItemIds) {
            arr.add((Object)itemId);
        }
        return arr;
    }

    public String toString() {
        return this.mItemIds.toString();
    }

    public CEventSelectItems addIds(@NotNull Collection<String> aItemIds) {
        for (String itemId : this.mItemIds) {
            this.addItemId(itemId);
        }
        return this;
    }
}

