/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventInsertMenuItem
implements IRemoteSkinEvent {
    private static final String KEY_ID = "id";
    private static final String KEY_TEXT = "text";
    private static final String KEY_POSITION = "pos";
    private final CEventWidgetId mId;
    private final CEventText mEventText;
    private final int mPosition;

    public CEventInsertMenuItem(@NotNull CEventWidgetId aId, @NotNull CEventText aEventText, int aPosition) {
        this.mId = aId;
        this.mEventText = aEventText;
        this.mPosition = aPosition;
    }

    @Nullable
    public static CEventInsertMenuItem create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(KEY_ID);
            CEventWidgetId id = CEventWidgetId.create(o);
            o = jo.getValue(KEY_TEXT);
            CEventText text = CEventText.create(o);
            if (id != null && text != null) {
                int position = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)KEY_POSITION, (int)0);
                return new CEventInsertMenuItem(id, text, position);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(KEY_ID, this.mId.toJson());
        jo.put(KEY_TEXT, this.mEventText.toJson());
        jo.put(KEY_POSITION, (Object)this.mPosition);
        return jo;
    }

    public CEventText getEventText() {
        return this.mEventText;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public CEventWidgetId getId() {
        return this.mId;
    }
}

