/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventBackgroundAt
implements IRemoteSkinEvent {
    public static final String INDEX = "index";
    public static final String COLOR = "color";
    private final int mIndex;
    private final Color mColor;

    public CEventBackgroundAt(int aIndex, @NotNull Color aColor) {
        this.mIndex = aIndex;
        this.mColor = aColor;
    }

    @Nullable
    public static CEventBackgroundAt create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int index = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)INDEX, (int)0);
            Object value = jo.getValue(COLOR);
            CEventColor data = CEventColor.create(value);
            if (data != null) {
                Color color = data.createColor();
                return new CEventBackgroundAt(index, color);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(INDEX, (Object)this.mIndex);
        CEventColor color = new CEventColor(this.mColor);
        jo.put(COLOR, color.toJson());
        return jo;
    }

    @NotNull
    public Color getColor() {
        return this.mColor;
    }

    public int getIndex() {
        return this.mIndex;
    }
}

