/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetList;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandSender;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetSet {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetSet.class);
    private final CWidgetList mWidgets;
    private final Properties mProperties;
    private final IRemoteSkinClientContext mClientContext;
    private final CTargetAddress mOwnerAddress;
    private final CWidgetSetId mWidgetSetId;
    private CWidget mRootWidget;
    private IJsonCommandSender mSender;
    private Map<String, ButtonGroup> mButtonGroups = null;

    public CWidgetSet(@NotNull CWidgetSetId aWidgetSetId, @NotNull IRemoteSkinClientContext aContext, @NotNull CTargetAddress aWidgetSetOwner) {
        this.mWidgetSetId = aWidgetSetId;
        this.mClientContext = aContext;
        this.mOwnerAddress = aWidgetSetOwner;
        this.mSender = aContext.getJsonCommandFactory().createSender();
        this.mProperties = new Properties();
        this.mWidgets = new CWidgetList();
    }

    private int getDeepNumberOfChildren() {
        return this.mWidgets.size();
    }

    public String toString() {
        return "WidgetSet " + this.getId() + " - Children:" + this.getDeepNumberOfChildren();
    }

    public void notifyWidgets(@NotNull ENotification aNotification, Object ... aObjects) {
        this.mWidgets.notifyWidgets(aNotification, aObjects);
    }

    @NotNull
    public IRemoteSkinClientContext getContext() {
        return this.mClientContext;
    }

    @NotNull
    public Properties getProperties() {
        return this.mProperties;
    }

    @NotNull
    public CWidgetSetId getId() {
        return this.mWidgetSetId;
    }

    @NotNull
    public CTargetAddress getOwnerAddress() {
        return this.mOwnerAddress;
    }

    @NotNull
    public CWidgetList getWidgets() {
        return this.mWidgets;
    }

    public void add(@NotNull CWidget aWidget, @Nullable CWidget aParent) {
        this.mWidgets.add(aWidget);
        if (aParent == null) {
            this.setRootWidget(aWidget);
        } else {
            aParent.addChildWidget(aWidget);
        }
    }

    public void add(@NotNull CWidget aWidget) {
        this.mWidgets.add(aWidget);
    }

    @Nullable
    public CWidget getRootWidget() {
        return this.mRootWidget;
    }

    public void setRootWidget(@NotNull CWidget aWidget) {
        if (this.mRootWidget != null) {
            LOG.warn("WidgetSet {} has already a root widget {} (new: {})", new Object[]{this.getId(), this.mRootWidget.getId(), aWidget.getId()});
        } else {
            this.mRootWidget = aWidget;
        }
    }

    public boolean isRootWidget(@NotNull CWidget aWidget) {
        return this.mRootWidget == aWidget;
    }

    public void replaceWidget(@NotNull CWidget aWidgetToReplace, @NotNull CWidget aReplacement, boolean aChildrenOnly) {
        this.mWidgets.replaceWidget(aWidgetToReplace, aReplacement, aChildrenOnly);
    }

    public void remove(@NotNull CWidget aWidget) {
        CWidget parent;
        this.mWidgets.remove(aWidget);
        if (this.mRootWidget == aWidget) {
            this.mRootWidget = null;
        }
        if ((parent = aWidget.getParent()) != null) {
            parent.removeChild(aWidget);
            aWidget.setParent(null);
        }
    }

    void notifyWidgetUnmounted(@NotNull CWidget aWidget) {
        this.mClientContext.notifyWidgetUnmounted(aWidget);
    }

    public void sendNotifications() {
        if (!this.mSender.isEmpty()) {
            this.mSender.send(this.getOwnerAddress(), this.getContext().getTarget());
            this.mSender = this.mClientContext.getJsonCommandFactory().createSender();
        }
    }

    public void addNotification(@NotNull CWidgetId aWidgetId, @NotNull String aKey, @NotNull Object aValue) {
        this.mSender.addAttribute(aWidgetId, aKey, aValue);
    }

    @Nullable
    public CWidget findComponent(@NotNull Component aComponent) {
        return this.mWidgets.findComponent(aComponent);
    }

    @Nullable
    public CWidget findPlaceHolder() {
        return this.mWidgets.findPlaceHolder();
    }

    @Nullable
    public CWidget findWidget(String aWidgetName) {
        return this.mWidgets.get(aWidgetName);
    }

    @Nullable
    public CWidget findWidget(CWidgetId aID) {
        return this.mWidgets.get(aID);
    }

    @NotNull
    public ButtonGroup getOrAddButtonGroup(@NotNull String aName) {
        ButtonGroup bg;
        String key = CUtilNormalize.normalize((String)aName);
        if (this.mButtonGroups == null) {
            this.mButtonGroups = new HashMap<String, ButtonGroup>();
            bg = null;
        } else {
            bg = this.mButtonGroups.get(key);
        }
        if (bg == null) {
            bg = new ButtonGroup();
            this.mButtonGroups.put(key, bg);
        }
        return bg;
    }
}

