/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.vars.IAttributeHandler;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CAttributeHandlerList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAttributeHandlerList.class);
    private final Map<String, IAttributeHandler> mHandlers = new HashMap<String, IAttributeHandler>();
    private final CWidget mWidget;

    public CAttributeHandlerList(@NotNull CWidget aWidget) {
        this.mWidget = aWidget;
    }

    public void addHandler(@NotNull String aAttribute, @NotNull IAttributeHandler aHandler) {
        String key = CUtilNormalize.normalize((String)aAttribute);
        this.mHandlers.put(key, aHandler);
    }

    public void handleAttribute(@NotNull String aKey, @Nullable Object aValue) {
        String key = CUtilNormalize.normalize((String)aKey);
        IAttributeHandler handler = this.mHandlers.get(key);
        if (handler != null) {
            try {
                boolean result = handler.handleAttribute(aKey, aValue);
                if (!result) {
                    String simpleName = this.getClass().getSimpleName();
                    String valueString = aValue == null ? "null" : aValue.toString();
                    LOG.error("Invalid Attribute Format: widget={}, key={}, value={}", new Object[]{simpleName, aKey, valueString});
                }
            }
            catch (Exception aE) {
                LOG.error((Throwable)aE, "Exception during handleAttribute({}) of {}", new Object[]{aKey, this.mWidget.getClass().getName()});
            }
        } else {
            LOG.error("Unsupported attribute for {}: {}", new Object[]{this.mWidget.getWidgetType(), aKey});
        }
    }
}

