/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.rolelist;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.rolelist.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyTableRowClicked;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbDeleteRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRightListForRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleList;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class C00311RoleList
extends CTarget {
    private static final IId MICRO_SERVICE_EDIT_ROLE = CIdFactory.fromObject((Object)"NY_WebDialogEditRole_00307");
    private static final IId MICRO_SERVICE_ADD_ROLE = CIdFactory.fromObject((Object)"NY_WebDialogAddRole_00306");
    private static final IId MICRO_SERVICE_YES_NO = CIdFactory.fromObject((Object)"NY_WebDialogYesNo_00001");
    private static final IId MICRO_SERVICE_GRANT_RIGHTS = CIdFactory.fromObject((Object)"NY_WebDialogGrantRights_00308");
    private static final IId MICRO_SERVICE_REVOKE_RIGHTS = CIdFactory.fromObject((Object)"NY_WebDialogRevokeRights_00314");
    private static final String ID_RIGHTS = "id_00311_rights";
    private static final String ID_00311_CREATED_BY = "id_00311_created_by";
    private static final String ID_00311_DESCRIPTION = "id_00311_description";
    private static final String ID_00311_ROLE_ID = "id_00311_role_id";
    private static final String ID_TABLE_ROLES = "id_00311_table_roles";
    private static final String ID_EDIT_ROLE = "id_00311_edit_role";
    private static final String ID_DELETE_ROLE = "id_00311_delete_role";
    private static final String ID_ADD_ROLE = "id_00311_add_role";
    private static final String ID_GRANT_RIGHTS = "id_00311_add_rights";
    private static final String ID_REVOKE_RIGHTS = "id_00311_revoke_rights";
    private static final String[] WIDGETS = new String[]{"id_00311_edit_role", "id_00311_delete_role", "id_00311_add_role", "id_00311_add_rights", "id_00311_revoke_rights"};
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mParentWidgetId;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private CTargetAddress mUserDbAddress;
    private List<String> mSortedRoleList = new ArrayList<String>();
    private CRole mRole;
    private String mNextRole;

    public C00311RoleList(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mParentWidgetId = aParentWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRoleList.ID, this::asyncGetAllRoles);
        this.addMessageHandler(CRecordUserDbGetRoleRecord.ID, this::asyncGetRoleRecord);
        this.addMessageHandler(CRecordWebNotifyTableRowClicked.ID, this::asyncWebNotifyTableRowClicked);
        this.addMessageHandler(CRecordUserDbGetRightListForRole.ID, this::asyncGetRightListForRole);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncNotifyDialogDismissed);
        this.addMessageHandler(CRecordUserDbDeleteRole.ID, this::asyncDeleteRole);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetAllRoles();
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick2.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on onClick", (Object[])new Object[0]);
        switch (id) {
            case "id_00311_edit_role": {
                this.openDialogEditRole();
                break;
            }
            case "id_00311_add_role": {
                this.openDialogAddRole();
                break;
            }
            case "id_00311_delete_role": {
                this.openDialogYesNo("Would you like to delete role " + this.mRole.getId() + "?");
                break;
            }
            case "id_00311_add_rights": {
                this.openDialogGrantRights(this.mRole.getId());
                break;
            }
            case "id_00311_revoke_rights": {
                this.openDialogRevokeRights(this.mRole.getId());
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetAllRoles(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                String[] roles = CRecordUserDbGetRoleList.getRoles((CRecord)aRecord, null);
                if (roles != null) {
                    ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(roles));
                    this.mSortedRoleList = roleList.stream().sorted(String::compareTo).collect(Collectors.toList());
                }
                this.createRoleTable();
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetRoleRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mUserDbAddress = aEnvelope.getSender();
                CRecord roleRecord = CRecordUserDbGetRoleRecord.getRoleRecord((CRecord)aRecord, null);
                this.mRole = CRole.fromRecord((CRecord)roleRecord);
                this.showRole(this.mRole);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebNotifyTableRowClicked(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyTableRowClicked.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)id, (String)"Missing id on NotifyTableRowClicked", (Object[])new Object[0]);
        String[] data = CRecordWebNotifyTableRowClicked.getData((CRecord)aRecord, null);
        if (data != null && data.length > 0) {
            String roleId = data[0];
            if (this.mRole != null && !this.mRole.getId().equals(roleId)) {
                this.markCurrentRoleInactive();
            }
            this.markRoleActive(roleId);
            this.sendGetRoleData(roleId);
            this.sendGetRightsForRole(roleId);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRightListForRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                CRecord[] rightRecords = CRecordUserDbGetRightListForRole.getRights((CRecord)aRecord, null);
                ArrayList<CRight> rightList = new ArrayList<CRight>();
                if (rightRecords != null) {
                    for (CRecord rightRecord : rightRecords) {
                        CRight right = CRight.fromRecord((CRecord)rightRecord);
                        rightList.add(right);
                    }
                }
                this.showRole(rightList);
                if (CUtilString.isValid((String)this.mNextRole)) {
                    this.markRoleActive(this.mNextRole);
                    this.sendGetRoleData(this.mNextRole);
                    this.mNextRole = null;
                }
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return aEnvelope.isAnswer();
    }

    private boolean asyncNotifyDialogDismissed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mNextRole = null;
        int reason = CRecordWebNotifyDialogDismissed.getReason((CRecord)aRecord, (int)-1);
        if (reason == 0) {
            String yesOrNo;
            IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId((CRecord)aRecord, null);
            this.mRunningMicroServices.remove(microserviceId);
            CStringProperties results = CRecordWebNotifyDialogDismissed.getResults((CRecord)aRecord, null);
            if (MICRO_SERVICE_EDIT_ROLE.equals((Object)microserviceId)) {
                this.sendGetRoleData(this.mRole.getId());
            }
            if (MICRO_SERVICE_GRANT_RIGHTS.equals((Object)microserviceId) || MICRO_SERVICE_REVOKE_RIGHTS.equals((Object)microserviceId)) {
                this.sendGetRightsForRole(this.mRole.getId());
            } else if (MICRO_SERVICE_ADD_ROLE.equals((Object)microserviceId)) {
                this.sendGetAllRoles();
                this.mNextRole = results.get("roleId");
            } else if (MICRO_SERVICE_YES_NO.equals((Object)microserviceId) && "yes".equals(yesOrNo = results.get("result"))) {
                this.sendDeleteRole();
            }
        } else if (reason == 1) {
            this.finish(reason);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteRole(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.sendGetAllRoles();
            } else if (resultCode == 5108) {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void createRoleTable() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00311_main.html");
        String table = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00311_table.html");
        String row = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00311_row.html");
        String currentTable = table;
        for (String roleId : this.mSortedRoleList) {
            String currentRow = row;
            currentRow = CUtilString.replaceAllOccurrences((String)currentRow, (String)"{role_id}", (String)roleId);
            currentTable = CUtilString.insertBeforeFirstOccurrence((String)currentTable, (String)"{row}", (String)currentRow);
        }
        currentTable = CUtilString.replaceFirstOccurrence((String)currentTable, (String)"{row}", (String)"");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{table_roles}", (String)currentTable);
        this.mWebApi.setInnerHtml(this.mParentWidgetId, main);
        this.mWebApi.addTableRowListener(ID_TABLE_ROLES);
        if (this.mNextRole == null) {
            this.mNextRole = this.mSortedRoleList.get(0);
        }
        if (CUtilString.isValid((String)this.mNextRole)) {
            this.sendGetRoleData(this.mNextRole);
            this.sendGetRightsForRole(this.mNextRole);
            this.markRoleActive(this.mNextRole);
        }
    }

    private void sendGetRoleData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetRoleRecord.create();
        CRecordUserDbGetRoleRecord.setRoleId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void sendGetAllRoles() throws CException {
        CRecord record = CRecordUserDbGetRoleList.create();
        this.sendMessageToSessionManager(record);
    }

    private void markCurrentRoleInactive() throws CException {
        this.mWebApi.removeClassFromElement("#row_" + this.mRole.getId(), "uk-active");
    }

    private void markRoleActive(@NotNull String aRoleId) throws CException {
        this.mWebApi.addClassToElement("#row_" + aRoleId, "uk-active");
    }

    private void sendGetRightsForRole(@NotNull String aRoleId) throws CException {
        CRecord record = CRecordUserDbGetRightListForRole.create();
        CRecordUserDbGetRightListForRole.setRoleId((CRecord)record, (String)aRoleId);
        this.sendMessageToSessionManager(record);
    }

    private void sendDeleteRole() throws CException {
        String id = this.mRole.getId();
        CRecord record = CRecordUserDbDeleteRole.create();
        CRecordUserDbDeleteRole.setRoleId((CRecord)record, (String)id);
        this.sendMessageToSessionManager(record);
    }

    private void showRole(@NotNull CRole aRole) throws CException {
        this.mWebApi.setInnerHtml(ID_00311_ROLE_ID, aRole.getId());
        this.mWebApi.setInnerHtml(ID_00311_DESCRIPTION, aRole.getDescription());
        this.mWebApi.setInnerHtml(ID_00311_CREATED_BY, aRole.getTimeCreated() + " by " + aRole.getCreatedByUser());
    }

    private void showRole(@NotNull List<CRight> aRights) throws CException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<ul class=\"uk-list uk-list-circle\">");
        for (CRight right : aRights) {
            sb.append("<li>").append(right).append("</li>");
        }
        sb.append("</ul>");
        this.mWebApi.setInnerHtml(ID_RIGHTS, sb.toString());
    }

    private void openDialogEditRole() throws CException {
        CStringProperties params = new CStringProperties();
        params.put("roleId", this.mRole.getId());
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_EDIT_ROLE, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogAddRole() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_ADD_ROLE, this.mSessionToken, "id_00300_modal", null);
    }

    private void openDialogGrantRights(@NotNull String aRoleId) throws CException {
        CStringProperties params = new CStringProperties();
        params.put("roleId", aRoleId);
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_GRANT_RIGHTS, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogRevokeRights(@NotNull String aRoleId) throws CException {
        CStringProperties params = new CStringProperties();
        params.put("roleId", aRoleId);
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_REVOKE_RIGHTS, this.mSessionToken, "id_00300_modal", params);
    }

    private void openDialogYesNo(String aMessage) throws CException {
        CStringProperties params = new CStringProperties();
        params.put("message", aMessage);
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_YES_NO, this.mSessionToken, "id_00300_modal", params);
    }

    private void finish(int aReason) throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

