/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.registry;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileEntry {
    @NotNull
    private final String mPath;
    @Nullable
    private final String mHash;
    @NotNull
    private final Instant mTimeOfLastModification;
    @NotNull
    private final Set<CTargetAddress> mTargets = new HashSet<CTargetAddress>();

    CFileEntry(@NotNull String aPath, @Nullable String aHash, @NotNull Instant aTimeOfLastModification, @NotNull CTargetAddress aSourceTarget) {
        this.mPath = CUtilPath.normalizeSlashesInPath((String)aPath);
        this.mHash = aHash;
        this.mTimeOfLastModification = aTimeOfLastModification;
        this.mTargets.add(aSourceTarget);
    }

    boolean isPathEqual(@NotNull String aPath) {
        return aPath.equals(this.mPath);
    }

    boolean isTimeEqualOrNewer(@NotNull Instant aTimeOfLastModification) {
        return aTimeOfLastModification.equals(this.mTimeOfLastModification) || aTimeOfLastModification.isAfter(this.mTimeOfLastModification);
    }

    boolean isTimeEqual(@NotNull Instant aTimeOfLastModification) {
        return this.mTimeOfLastModification.equals(aTimeOfLastModification);
    }

    boolean isHashEqual(@NotNull String aHash) {
        return this.mHash != null && this.mHash.equals(aHash);
    }

    public boolean isHashAndTimeEqual(String aHash, Instant aTimeOfLastModification) {
        return this.mHash != null && this.mHash.equals(aHash) && this.mTimeOfLastModification.equals(aTimeOfLastModification);
    }

    @NotNull
    CTargetAddress getSourceTarget() {
        ArrayList<CTargetAddress> list = new ArrayList<CTargetAddress>(this.mTargets);
        Random random = new Random();
        int randomIndex = random.nextInt(list.size());
        return (CTargetAddress)list.get(randomIndex);
    }

    @NotNull
    Set<CTargetAddress> getTargets() {
        return this.mTargets;
    }

    @NotNull
    public String getPath() {
        return this.mPath;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CFileEntry that = (CFileEntry)aObject;
        if (!this.mPath.equals(that.mPath)) {
            return false;
        }
        if (!Objects.equals(this.mHash, that.mHash)) {
            return false;
        }
        return this.mTimeOfLastModification.equals(that.mTimeOfLastModification);
    }

    public int hashCode() {
        int result = this.mPath.hashCode();
        result = 31 * result + (this.mHash != null ? this.mHash.hashCode() : 0);
        result = 31 * result + this.mTimeOfLastModification.hashCode();
        return result;
    }

    @NotNull
    public Instant getTimeOfLastModification() {
        return this.mTimeOfLastModification;
    }

    @Nullable
    String getHash() {
        return this.mHash;
    }

    public boolean match(@NotNull String aPath, @Nullable String aHash) {
        if (this.mPath.equals(aPath)) {
            return CUtilString.equals((String)this.mHash, (String)aHash);
        }
        return false;
    }

    public void addTargetAddress(@NotNull CTargetAddress aSourceTarget) {
        this.mTargets.add(aSourceTarget);
    }

    public void removeAddress(@NotNull CTargetAddress aTargetAddress) {
        this.mTargets.remove(aTargetAddress);
    }
}

