/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.CH2Table;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRightList;
import de.sillysky.nyssr.util.time.CUtilTimestamp;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class CTableRoleRightRelation
extends CH2Table {
    protected CTableRoleRightRelation(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        super(aConnection, aLogger, aName);
        this.createTable();
    }

    private void createTable() {
        if (!this.existTable("X052_ROLE_RIGHT")) {
            String sql = "CREATE TABLE IF NOT EXISTS X052_ROLE_RIGHT(X052_ROLE_ID VARCHAR not null,X052_RIGHT_ID VARCHAR not null,X052_TIME_CREATED TIMESTAMP default now() not null,X052_CREATED_BY VARCHAR,constraint X052_ROLE_RIGHT_PK primary key (X052_ROLE_ID, X052_RIGHT_ID),FOREIGN KEY (X052_ROLE_ID) REFERENCES X053_ROLE(X053_ROLE_ID),FOREIGN KEY (X052_RIGHT_ID) REFERENCES X054_RIGHT(X054_RIGHT_ID))";
            this.executeUpdate("CREATE TABLE IF NOT EXISTS X052_ROLE_RIGHT(X052_ROLE_ID VARCHAR not null,X052_RIGHT_ID VARCHAR not null,X052_TIME_CREATED TIMESTAMP default now() not null,X052_CREATED_BY VARCHAR,constraint X052_ROLE_RIGHT_PK primary key (X052_ROLE_ID, X052_RIGHT_ID),FOREIGN KEY (X052_ROLE_ID) REFERENCES X053_ROLE(X053_ROLE_ID),FOREIGN KEY (X052_RIGHT_ID) REFERENCES X054_RIGHT(X054_RIGHT_ID))", "createTable", null);
            this.addRightToRole("admin", "UserManager", "NY_CreateUser");
            this.addRightToRole("admin", "UserManager", "NY_UpdateUser");
            this.addRightToRole("admin", "UserManager", "NY_DeleteUser");
            this.addRightToRole("admin", "UserManager", "NY_ChangePassword");
            this.addRightToRole("admin", "UserManager", "NY_CreateRole");
            this.addRightToRole("admin", "UserManager", "NY_EditRole");
            this.addRightToRole("admin", "UserManager", "NY_AddRoleToUser");
            this.addRightToRole("admin", "UserManager", "NY_RemoveRoleFromUser");
            this.addRightToRole("admin", "UserManager", "NY_DeleteRole");
            this.addRightToRole("admin", "UserManager", "NY_CreateRight");
            this.addRightToRole("admin", "UserManager", "NY_EditRight");
            this.addRightToRole("admin", "UserManager", "NY_DeleteRight");
            this.addRightToRole("admin", "UserManager", "NY_GrantRight");
            this.addRightToRole("admin", "UserManager", "NY_RevokeRight");
            this.addRightToRole("admin", "UserManager", "NY_ChangeRight");
            this.addRightToRole("admin", "Administrator", "NY_StartAdminTool");
            this.addRightToRole("admin", "UserViewer", "NY_GetRightList");
            this.addRightToRole("admin", "UserViewer", "NY_GetUserList");
            this.addRightToRole("admin", "UserViewer", "NY_GetRoles");
            this.addRightToRole("admin", "UserViewer", "NY_GetUserData");
            this.addRightToRole("admin", "UserViewer", "NY_GetRoleData");
            this.addRightToRole("admin", "UserViewer", "NY_GetRightData");
            this.addRightToRole("admin", "UserViewer", "NY_GetListOfRoles");
            this.addRightToRole("admin", "User", "NY_VerifyUser");
            this.addRightToRole("admin", "Guests", "NY_VerifyUser");
            this.addRightToRole("admin", "UserVerifier", "NY_VerifyUser");
            this.addRightToRole("admin", "Administrator", "NY_Shutdown");
            this.addRightToRole("admin", "Administrator", "NY_SoftwareUpdate");
            this.addRightToRole("admin", "Administrator", "NY_EditConfiguration");
        }
    }

    void addRightToRole(@NotNull String aCurrentUser, @NotNull String aRoleId, @NotNull String aRightId) {
        String sql = "INSERT INTO X052_ROLE_RIGHT (X052_ROLE_ID,X052_RIGHT_ID,X052_TIME_CREATED,X052_CREATED_BY) VALUES (?, ?, ?, ?)";
        this.executeUpdate("INSERT INTO X052_ROLE_RIGHT (X052_ROLE_ID,X052_RIGHT_ID,X052_TIME_CREATED,X052_CREATED_BY) VALUES (?, ?, ?, ?)", "insert", statement -> {
            statement.setString(1, aRoleId);
            statement.setString(2, aRightId);
            statement.setTimestamp(3, CUtilTimestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.now()));
            statement.setString(4, aCurrentUser);
        });
    }

    public CRightList getRightsForRole(@NotNull String aRoleId) {
        String sql = "SELECT r.X054_RIGHT_ID, r.X054_DESCRIPTION, r.X054_PROTECTED FROM X054_RIGHT r INNER JOIN X052_ROLE_RIGHT rr ON r.X054_RIGHT_ID = rr.X052_RIGHT_ID WHERE rr.X052_ROLE_ID = ?";
        CRightList rightsList = new CRightList();
        this.executeQuery("SELECT r.X054_RIGHT_ID, r.X054_DESCRIPTION, r.X054_PROTECTED FROM X054_RIGHT r INNER JOIN X052_ROLE_RIGHT rr ON r.X054_RIGHT_ID = rr.X052_RIGHT_ID WHERE rr.X052_ROLE_ID = ?", "getRightsForRole", st -> st.setString(1, aRoleId), rs -> {
            while (rs.next()) {
                String rightId = rs.getString(1);
                String rightDescription = rs.getString(2);
                boolean isProtected = rs.getBoolean(3);
                rightsList.add(new CRight(rightId, rightDescription, isProtected));
            }
            return rightsList;
        });
        return rightsList;
    }

    public long getRightsCount() {
        String sql = "SELECT COUNT(*) FROM X052_ROLE_RIGHT";
        return this.executeQueryLong("SELECT COUNT(*) FROM X052_ROLE_RIGHT", "getRightCount", null);
    }

    public CRightList getRightsForRoles(@NotNull Collection<String> aRoleIds) {
        String inClause = this.createInClause(aRoleIds);
        String sql = "SELECT r.X054_RIGHT_ID, r.X054_DESCRIPTION, r.X054_PROTECTED FROM X054_RIGHT r INNER JOIN X052_ROLE_RIGHT rr ON r.X054_RIGHT_ID = rr.X052_RIGHT_ID WHERE rr.X052_ROLE_ID " + inClause;
        CRightList rightsList = new CRightList();
        this.executeQuery(sql, "getRightsForRole", null, rs -> {
            while (rs.next()) {
                String rightId = rs.getString(1);
                String rightDescription = rs.getString(2);
                boolean isProtected = rs.getBoolean(3);
                rightsList.add(new CRight(rightId, rightDescription, isProtected));
            }
            return rightsList;
        });
        return rightsList;
    }

    void removeRole(@NotNull String aRoleId) {
        String sql = "DELETE FROM X052_ROLE_RIGHT WHERE X052_ROLE_ID=?";
        this.executeUpdate("DELETE FROM X052_ROLE_RIGHT WHERE X052_ROLE_ID=?", "removeRole", statement -> statement.setString(1, aRoleId));
    }

    void removeRight(@NotNull String aRightId) {
        String sql = "DELETE FROM X052_ROLE_RIGHT WHERE X052_RIGHT_ID=?";
        this.executeUpdate("DELETE FROM X052_ROLE_RIGHT WHERE X052_RIGHT_ID=?", "removeRight", statement -> statement.setString(1, aRightId));
    }

    void removeRightFromRole(@NotNull String aRoleId, @NotNull String aRightId) {
        String sql = "DELETE FROM X052_ROLE_RIGHT WHERE X052_ROLE_ID=? AND X052_RIGHT_ID=?";
        this.executeUpdate("DELETE FROM X052_ROLE_RIGHT WHERE X052_ROLE_ID=? AND X052_RIGHT_ID=?", "removeRightFromRole", statement -> {
            statement.setString(1, aRoleId);
            statement.setString(2, aRightId);
        });
    }
}

