/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.file.registry.CFileEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileEntryList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFileEntryList.class);
    private final Set<CFileEntry> mFiles = new HashSet<CFileEntry>();
    private final Map<String, List<CFileEntry>> mFilesByPath = new HashMap<String, List<CFileEntry>>();
    private final Map<String, List<CFileEntry>> mFilesByHash = new HashMap<String, List<CFileEntry>>();

    CFileEntryList() {
    }

    void add(@NotNull CFileEntry aFileEntry) {
        String path = aFileEntry.getPath();
        path = CUtilPath.normalizeSlashesInPath((String)path);
        String hash = aFileEntry.getHash();
        CFileEntry e = this.get(aFileEntry.getPath(), aFileEntry.getHash());
        if (e == null) {
            this.mFiles.add(aFileEntry);
            this.addToMap(this.mFilesByPath, path, aFileEntry);
            if (hash != null) {
                this.addToMap(this.mFilesByHash, hash, aFileEntry);
            }
        } else {
            e.addTargetAddress(aFileEntry.getSourceTarget());
        }
    }

    private void addToMap(@NotNull Map<String, List<CFileEntry>> aMap, @NotNull String aValue, @NotNull CFileEntry aFileEntry) {
        List<CFileEntry> list = aMap.get(aValue);
        if (list == null) {
            list = new ArrayList<CFileEntry>();
            list.add(aFileEntry);
            aMap.put(aValue, list);
        } else {
            list.add(aFileEntry);
        }
    }

    @Nullable
    private CFileEntry get(@NotNull String aPath, @Nullable String aHash) {
        for (CFileEntry item : this.mFiles) {
            if (!item.match(aPath, aHash)) continue;
            return item;
        }
        return null;
    }

    void remove(@NotNull CTargetAddress aTargetAddress) {
        for (CFileEntry entry : this.mFiles) {
            entry.removeAddress(aTargetAddress);
        }
    }

    @NotNull
    private List<CFileEntry> getByPath(@NotNull String aPath) {
        ArrayList<CFileEntry> result = new ArrayList<CFileEntry>();
        String path = CUtilPath.normalizeSlashesInPath((String)aPath);
        List<CFileEntry> list = this.mFilesByPath.get(path);
        if (list != null) {
            result.addAll(list);
        }
        return result;
    }

    List<CFileEntry> getEntries(@NotNull String aPath, @NotNull Instant aTimeOfLastModification) {
        List<CFileEntry> list = this.getByPath(aPath);
        list.removeIf(entry -> !entry.getTimeOfLastModification().equals(aTimeOfLastModification));
        return list;
    }

    public List<CFileEntry> getEntries(@NotNull String aPath, @NotNull String aHash, @NotNull Instant aTimeOfLastModification) {
        List<CFileEntry> list = this.getByPath(aPath);
        list.removeIf(entry -> !CUtilString.equals((String)entry.getHash(), (String)aHash));
        list.removeIf(entry -> !entry.getTimeOfLastModification().equals(aTimeOfLastModification));
        return list;
    }

    @Nullable
    public List<CFileEntry> getEntries(@NotNull String aPath, @NotNull String aHash) {
        List<CFileEntry> list = this.getByPath(aPath);
        list.removeIf(entry -> !CUtilString.equals((String)entry.getHash(), (String)aHash));
        return list;
    }

    @Nullable
    public List<CFileEntry> getNewestEntries(@NotNull String aPath) {
        Instant maxTime;
        List<CFileEntry> ee = this.getByPath(aPath);
        if (!ee.isEmpty() && (maxTime = (Instant)ee.stream().max(Comparator.comparing(CFileEntry::getTimeOfLastModification)).map(CFileEntry::getTimeOfLastModification).orElse(null)) != null) {
            return ee.stream().filter(entry -> entry.getTimeOfLastModification().equals(maxTime)).collect(Collectors.toList());
        }
        return null;
    }

    @NotNull
    String[] getFilePaths(@NotNull String aDirectory) {
        int length = aDirectory.length();
        ArrayList<String> paths = new ArrayList<String>();
        for (CFileEntry entry : this.mFiles) {
            String tail;
            String path = entry.getPath();
            if (!CUtilString.isEmpty((String)aDirectory) && !path.startsWith(aDirectory) || (tail = path.substring(length)).indexOf(92) > 0 || tail.indexOf(47) > 0) continue;
            paths.add(path);
        }
        return paths.toArray(new String[0]);
    }

    @Nullable
    List<CFileEntry> getFileInfo(@NotNull String aPath) {
        return this.getByPath(aPath);
    }

    void notifyRemoteNodeRemoved(@NotNull CNodeAddress aNodeAddress) {
        int count = 0;
        for (CFileEntry entry : this.mFiles) {
            Set<CTargetAddress> targets = entry.getTargets();
            Iterator<CTargetAddress> it = targets.iterator();
            while (it.hasNext()) {
                CTargetAddress next = it.next();
                if (!aNodeAddress.equals((Object)next.getNodeAddress())) continue;
                ++count;
                it.remove();
            }
        }
        LOG.info("{} files removed from registry because node {} has vanished.", new Object[]{count, aNodeAddress});
    }
}

