/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.socket;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.kernel.records.CRecordDismiss;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CWidgetSetProviderList {
    private final Map<String, CTargetAddress> mWidgetOwners = new HashMap<String, CTargetAddress>();

    CWidgetSetProviderList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProvider(@NotNull CTargetAddress aAddress) {
        CWidgetSetProviderList cWidgetSetProviderList = this;
        synchronized (cWidgetSetProviderList) {
            this.mWidgetOwners.values().removeIf(v -> v.equals((Object)aAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWidget(@NotNull String aId, @NotNull CTargetAddress aAddress) {
        CWidgetSetProviderList cWidgetSetProviderList = this;
        synchronized (cWidgetSetProviderList) {
            this.mWidgetOwners.put(aId, aAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWidget(@NotNull String aId) {
        CWidgetSetProviderList cWidgetSetProviderList = this;
        synchronized (cWidgetSetProviderList) {
            this.mWidgetOwners.remove(aId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CTargetAddress getProviderForWidget(@NotNull String aId) {
        CWidgetSetProviderList cWidgetSetProviderList = this;
        synchronized (cWidgetSetProviderList) {
            return this.mWidgetOwners.get(aId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTargets(ITarget aTarget) {
        CWidgetSetProviderList cWidgetSetProviderList = this;
        synchronized (cWidgetSetProviderList) {
            HashSet<CTargetAddress> addresses = new HashSet<CTargetAddress>(this.mWidgetOwners.values());
            for (CTargetAddress address : addresses) {
                try {
                    CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
                    CRecord record = CRecordDismiss.create();
                    aTarget.send(env, record);
                }
                catch (CException cException) {}
            }
        }
    }
}

