/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.service;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.registry.CMicroServiceConstants;
import de.sillysky.nyssr.file.registry.records.CRecordFileRegistryAddFileInfos;
import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreAddLocalFile;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreGetFileInfo;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.file.store.CFileStoreConstants;
import de.sillysky.nyssr.impl.file.store.database.CDirectoryScanner;
import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.impl.file.store.database.CFileEntryList;
import de.sillysky.nyssr.impl.file.store.getfile.CDownloadFileJob;
import de.sillysky.nyssr.impl.file.store.getfile.CIncomingRequestFileHandler;
import de.sillysky.nyssr.impl.file.store.importfile.CDirectoryWatcher;
import de.sillysky.nyssr.impl.file.store.importfile.CImportFileHandler;
import de.sillysky.nyssr.impl.file.store.importfile.CJobImportFile;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreAddFileToList;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreGetChunk;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreNotifyFileDownloaded;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreNotifyFileImported;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreStoreFile;
import de.sillysky.nyssr.impl.file.store.service.CDeliverChunkHandler;
import de.sillysky.nyssr.impl.file.store.service.CFileDto;
import de.sillysky.nyssr.impl.file.store.service.CIncomingGetFileHandler;
import de.sillysky.nyssr.impl.file.store.service.IDependencies;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.impl.file.store.service.INotifyFileTransferCompleted;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.job.IJob;
import de.sillysky.nyssr.job.IJobEngine;
import de.sillysky.nyssr.job.records.CRecordNoMoreJobs;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileStore
extends CTarget
implements IService,
INotifyFileTransferCompleted,
IFileStore {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFileStore.class);
    private static final IId STARTUP = CIdFactory.fromObject((Object)"StartMe");
    private static final IId REGISTER_FILES_TIMER = CIdFactory.fromObject((Object)"RegisterFilesTimer");
    static final long REGISTER_FILES_TIMER_DELAY = 5000L;
    private final CFileEntryList mFileList = new CFileEntryList();
    private CTimer mRegisterFilesTimer;
    private final int mChunkSize;
    private final IDependencies mDependencies;
    private Path mDirectoryForIncomingFiles = null;
    private Path mDirectoryForIndexedFiles = null;
    private Path mDirectoryForIncompleteFiles = null;
    private IJobEngine mJobEngine;
    private CImportFileHandler mImportFileHandler;
    private final CDeliverChunkHandler mDeliverChunkHandler;
    private final CIncomingGetFileHandler mIncomingGetFileHandler;
    private CDirectoryWatcher mDirectoryWatcher;

    CFileStore(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Path storagePath = kc.getStoragePath();
        Preferences preferences = kc.getPreferences("file.store");
        String s = preferences.get("chunk.size", null);
        this.mChunkSize = CUtilInteger.fromString((String)s, (int)10000);
        if (storagePath != null) {
            String path = preferences.get("path", "FileStore");
            Path basePath = CUtilPath.resolvePath((String)storagePath.toString(), (String)path);
            this.mDirectoryForIndexedFiles = CUtilPath.resolvePath((String)basePath.toString(), (String)"indexed");
            this.mDirectoryForIncomingFiles = CUtilPath.resolvePath((String)basePath.toString(), (String)"incoming");
            this.mDirectoryForIncompleteFiles = basePath.resolve("incomplete");
            CUtilFile.createDirectories((File)this.mDirectoryForIncompleteFiles.toFile());
            CUtilFile.createDirectories((File)this.mDirectoryForIncomingFiles.toFile());
            CUtilFile.createDirectories((File)this.mDirectoryForIncompleteFiles.toFile());
        }
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordFileStoreStoreFile.ID, this::asyncStoreFile);
        this.addMessageHandler(STARTUP, this::asyncStartUp);
        this.addMessageHandler(CRecordFileStoreNotifyFileImported.ID, this::asyncNotifyFileImported);
        this.addMessageHandler(CRecordNoMoreJobs.ID, this::asyncNoMoreJobs);
        this.addMessageHandler(CRecordFileStoreGetFileInfo.ID, this::asyncGetFileInfo);
        this.addMessageHandler(CRecordFileStoreGetChunk.ID, this::asyncGetChunk);
        this.addMessageHandler(CRecordFileStoreAddLocalFile.ID, this::asyncAddLocalFile);
        this.addMessageHandler(CRecordFileStoreAddFileToList.ID, this::asyncAddFileToList);
        this.addMessageHandler(REGISTER_FILES_TIMER, this::asyncRegisterFilesTimer);
        CIncomingRequestFileHandler incomingRequestFileHandler = new CIncomingRequestFileHandler(this);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, incomingRequestFileHandler::asyncRequestFile);
        this.addMessageHandler(CRecordFileStoreNotifyFileDownloaded.ID, incomingRequestFileHandler::asyncNotifyFileDownloaded);
        this.mDeliverChunkHandler = new CDeliverChunkHandler(this);
        this.mIncomingGetFileHandler = new CIncomingGetFileHandler(this);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.createNamespaceAndRegisterTarget();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.dismissJobEngine();
        if (this.mDirectoryWatcher != null) {
            this.mDirectoryWatcher.stop();
        }
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        CUtilCheck.checkNotNull((Object)ns, (String)"SYSTEM not found", (Object[])new Object[0]);
        IRecordHelper helper = this.mDependencies.getRecordHelper();
        helper.registerServiceAndAddObserver(CRecordFileStoreRequestFile.class, (ITarget)this, ns, false);
        helper.registerServiceAndAddObserver(CRecordFileStoreAddLocalFile.class, (ITarget)this, ns, false);
        helper.registerServiceAndAddObserver(CRecordFileStoreGetFileInfo.class, (ITarget)this, ns, false);
        this.createJobEngine();
        this.mImportFileHandler = new CImportFileHandler(this.mDependencies, this);
        this.triggerThisTarget(STARTUP);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartUp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CDirectoryScanner scanner = new CDirectoryScanner(this.mDirectoryForIndexedFiles);
        scanner.scan(this.mFileList);
        this.mImportFileHandler.importIncomingFiles();
        this.mDirectoryWatcher = new CDirectoryWatcher(this.mDependencies, this.mDirectoryForIncomingFiles, this.mDirectoryForIndexedFiles, this.mJobEngine, this.getAddress());
        this.mDirectoryWatcher.start();
        this.mRegisterFilesTimer = new CTimer(this.mDependencies.getTimerManager(), REGISTER_FILES_TIMER, this.getAddress(), 5000L, false, null);
        this.mRegisterFilesTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStoreFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordFileStoreStoreFile.getFile(aRecord, null);
        CUtilCheck.checkArgument((Object)record, (String)"File");
        CUtilCheck.checkEqualEx((Object)record.getId(), (Object)CRecordFileStoreFile.ID, (String)"File Record has invalid ID", (Object[])new Object[0]);
        String path = CRecordFileStoreFile.getPath((CRecord)record, (String)"");
        String hash = CRecordFileStoreFile.getHash((CRecord)record, (String)"");
        long length = CRecordFileStoreFile.getFileLength((CRecord)record, (long)-1L);
        Instant timeOfCreation = CRecordFileStoreFile.getTimeOfCreation((CRecord)record, null);
        Instant timeOfLastModification = CRecordFileStoreFile.getTimeOfLastModification((CRecord)record, null);
        CUtilCheck.checkEmptyStringEx((Object)path, (String)"Path missing", (Object[])new Object[0]);
        CUtilCheck.checkEmptyStringEx((Object)hash, (String)"Hash missing", (Object[])new Object[0]);
        CUtilCheck.checkTrueEx((length < 0L ? 1 : 0) != 0, (String)"Invalid Length", (Object[])new Object[0]);
        CUtilCheck.checkNotNullEx((Object)timeOfCreation, (String)"Invalid time of creation", (Object[])new Object[0]);
        CUtilCheck.checkNotNullEx((Object)timeOfLastModification, (String)"Invalid time of last modification", (Object[])new Object[0]);
        LOG.debug("Store File: {}: hash={}, length={}", new Object[]{path, hash, length});
        CFileEntry e = this.mFileList.getByHash(hash);
        if (e == null) {
            LOG.debug("Deliver File {}", new Object[]{path});
            this.addFileToDownload(hash, path, length, timeOfCreation, timeOfLastModification, aEnvelope.getSender());
            this.setDirty();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    public boolean asyncGetFileInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mIncomingGetFileHandler.processIncomingGetFile(aEnvelope, aRecord);
        return true;
    }

    public boolean asyncGetChunk(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDeliverChunkHandler.processRequestChunk(aEnvelope, aRecord);
        return true;
    }

    private boolean asyncNotifyFileImported(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord fileRecord = CRecordFileStoreNotifyFileImported.getFileRecord(aRecord, null);
        String path = CRecordFileStoreFile.getPath((CRecord)fileRecord, null);
        long fileLength = CRecordFileStoreFile.getFileLength((CRecord)fileRecord, (long)0L);
        String hash = CRecordFileStoreFile.getHash((CRecord)fileRecord, null);
        Instant creationTimeInstant = CRecordFileStoreFile.getTimeOfCreation((CRecord)fileRecord, null);
        Instant modifiedTimeInstant = CRecordFileStoreFile.getTimeOfLastModification((CRecord)fileRecord, null);
        Path filePath = this.mDirectoryForIndexedFiles.resolve(path);
        File file = filePath.toFile();
        FileTime creationTime = FileTime.from(creationTimeInstant);
        FileTime modifiedTime = FileTime.from(modifiedTimeInstant);
        CFileEntry entry = new CFileEntry(hash, path, file, fileLength, creationTime, modifiedTime);
        this.mFileList.add(entry);
        this.setDirty();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNoMoreJobs(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddLocalFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String pathString = CRecordFileStoreAddLocalFile.getPath((CRecord)aRecord, null);
        if (CUtilString.isEmpty((String)pathString)) {
            aEnvelope.setResult(8, "Missing path");
        }
        String relativeDestPathString = CRecordFileStoreAddLocalFile.getRelativeDestinationPath((CRecord)aRecord, (String)"");
        Path path = Paths.get(pathString, new String[0]);
        File file = path.toFile();
        if (!file.exists()) {
            aEnvelope.setResult(2213, "File doesn't exist");
        }
        if (!file.isFile()) {
            aEnvelope.setResult(2203, "File is no file");
        }
        if (!file.canRead()) {
            aEnvelope.setResult(2214, "Reading impossible");
        }
        String fileName = relativeDestPathString.isEmpty() ? file.getName() : relativeDestPathString + File.separator + file.getName();
        CJobImportFile job = new CJobImportFile(this.mDependencies, path, this.mDirectoryForIndexedFiles, fileName, this.getAddress(), false);
        this.mJobEngine.appendJob((IJob)job);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddFileToList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordFileStoreAddFileToList.getFile(aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing file record", (Object[])new Object[0]);
        CFileEntry entry = CFileEntry.fromRecord(record);
        this.mFileList.add(entry);
        this.setDirty();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterFilesTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mRegisterFilesTimer.notifyTriggerOccurred();
        LOG.debug("Register files");
        this.registerFiles();
        aEnvelope.setResultSuccess();
        return true;
    }

    public void registerFiles() throws CException {
        ArrayList<CRecord> list = new ArrayList<CRecord>();
        for (CFileEntry fileEntry : this.mFileList.getFileList()) {
            if (fileEntry.isRegistered()) continue;
            list.add(fileEntry.toFileInfoRecord(this.getAddress()));
            fileEntry.setRegistered(true);
        }
        if (!list.isEmpty()) {
            CRecord[] arr = list.toArray(new CRecord[0]);
            CEnvelope env = CEnvelope.forMicroService((IId)CMicroServiceConstants.MICRO_SERVICE_ID);
            CRecord record = CRecordFileRegistryAddFileInfos.create();
            CRecordFileRegistryAddFileInfos.setFileInfo((CRecord)record, (CRecord[])arr);
            this.sendNotification(env, record);
        }
    }

    private void dismissJobEngine() throws CException {
        if (this.mJobEngine != null) {
            this.mJobEngine.dismiss();
            this.mJobEngine = null;
        }
    }

    private void addFileToDownload(@NotNull String aHash, @NotNull String aPath, long aLength, @NotNull Instant aTimeOfCreation, @NotNull Instant aTimeOfLastModification, @NotNull CTargetAddress aSender) {
        CDownloadFileJob job = new CDownloadFileJob(this, aPath, aHash, aLength, aTimeOfCreation, aTimeOfLastModification, aSender);
        this.mJobEngine.appendJob((IJob)job);
    }

    private void createJobEngine() throws CException {
        if (this.mJobEngine == null) {
            this.mJobEngine = this.mDependencies.getJobEngineFactory().createEngine("FileStore");
            this.mJobEngine.setOwner(this.getAddress());
            for (int i = 0; i < 3; ++i) {
                this.mJobEngine.appendThread("Store" + (i + 1), CFileStoreConstants.JOB_PRIORITY, 1);
            }
            this.mJobEngine.start();
        }
    }

    private void createNamespaceAndRegisterTarget() throws CException {
        IId nid = CIdFactory.fromObject((Object)"FileStore".toUpperCase());
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "FileStore");
        ITargetRegistry targetRegistry = ns.getTargetRegistry();
        IId tid = CIdFactory.fromObject((Object)"FileStore");
        targetRegistry.registerTarget((ITarget)this, tid);
    }

    public CFileEntryList getFileList() {
        return this.mFileList;
    }

    public void setDirty() {
        if (this.mRegisterFilesTimer != null) {
            this.mRegisterFilesTimer.startIf();
        }
    }

    @Override
    public void notifyFileTransferCompleted(@NotNull CFileDto aFileDto, @Nullable File aFile, byte[] aBytes) {
        String hash = aFileDto.getHash();
        FileTime timeOfCreation = aFileDto.getTimeOfCreation();
        FileTime timeOfLastModification = aFileDto.getTimeOfLastModification();
        String relativePath = aFileDto.getRelativePath();
        File file = null;
        if (aFile != null) {
            Path path = this.mDirectoryForIncomingFiles.resolve(relativePath + "._32_" + hash);
            CUtilFileStore.rename(this, aFile, relativePath, hash, timeOfCreation, timeOfLastModification);
            file = path.toFile();
        }
        CFileEntry entry = new CFileEntry(hash, relativePath, file, aFileDto.getLength(), timeOfCreation, timeOfLastModification);
        entry.setBytes(aBytes);
        this.mFileList.add(entry);
    }

    @Override
    public int getChunkSize() {
        return this.mChunkSize;
    }

    @Override
    @NotNull
    public ITarget getTarget() {
        return this;
    }

    @Override
    @Nullable
    public CFileEntry getFileEntryByHash(@NotNull String aHash) {
        return this.mFileList.getByHash(aHash);
    }

    @Override
    @Nullable
    public CFileEntry getFileEntryByPath(@NotNull String aPath) {
        return this.mFileList.getByPath(aPath);
    }

    @Override
    public void addNewFileEntry(@NotNull CFileEntry aFileEntry) {
        this.mFileList.add(aFileEntry);
        this.setDirty();
    }

    @Override
    @NotNull
    public IJobEngine getJobEngine() {
        return this.mJobEngine;
    }

    @Override
    @Nullable
    public Path getDirectoryForIndexedFiles() {
        return this.mDirectoryForIndexedFiles;
    }

    @Override
    @Nullable
    public Path getDirectoryForIncomingFiles() {
        return this.mDirectoryForIncomingFiles;
    }

    @Override
    @Nullable
    public Path getDirectoryForIncompleteFiles() {
        return this.mDirectoryForIncompleteFiles;
    }
}

