/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodes;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class CKeyHelper {
    private static final ILogger LOG_PREP = CLoggerFactory.getLogger(CKeyHelper.class);
    private static final AtomicReference<KeyPair> mKeyPair = new AtomicReference();

    private CKeyHelper() {
    }

    private static KeyPair createRsaKey() {
        KeyPair keyPair;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            keyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            LOG_PREP.error("RSA not supported.");
            keyPair = null;
        }
        return keyPair;
    }

    public static SecretKey createSessionKey() {
        SecretKey key;
        try {
            key = KeyGenerator.getInstance("AES").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOG_PREP.error((Throwable)e, "Can't create session Key.");
            key = null;
        }
        return key;
    }

    public static PublicKey decodePublicKey(byte[] aEncodedPublicKey) {
        PublicKey publicKey = null;
        if (aEncodedPublicKey != null) {
            try {
                X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(aEncodedPublicKey);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                publicKey = keyFactory.generatePublic(publicSpec);
            }
            catch (Exception e) {
                LOG_PREP.error((Throwable)e, "Error decrypting public key.");
            }
        }
        return publicKey;
    }

    private static SecretKey decodeSessionKey(byte[] aEncodedSessionKey) {
        SecretKeySpec sessionKey = null;
        if (aEncodedSessionKey != null) {
            try {
                sessionKey = new SecretKeySpec(aEncodedSessionKey, 0, aEncodedSessionKey.length, "AES");
            }
            catch (Exception e) {
                LOG_PREP.error((Throwable)e, "Error decrypting public key.");
            }
        }
        return sessionKey;
    }

    public static SecretKey decryptSessionKey(byte[] aEncryptedSessionKey, PrivateKey aPrivateKey) {
        SecretKey sessionKey = null;
        if (aEncryptedSessionKey != null && aPrivateKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                cipher.init(2, aPrivateKey);
                byte[] sessionKeyBytes = cipher.doFinal(aEncryptedSessionKey);
                sessionKey = CKeyHelper.decodeSessionKey(sessionKeyBytes);
            }
            catch (Exception e) {
                LOG_PREP.error("Can't decrypt session Key: {}", new Object[]{e.getMessage()});
                sessionKey = null;
            }
        }
        return sessionKey;
    }

    public static byte[] encodePublicKey(PublicKey aPublicKey) {
        byte[] result = null;
        if (aPublicKey != null) {
            result = aPublicKey.getEncoded();
        }
        return result;
    }

    private static byte[] encodeSessionKey(SecretKey aSessionKey) {
        byte[] result = null;
        if (aSessionKey != null) {
            result = aSessionKey.getEncoded();
        }
        return result;
    }

    public static byte[] encryptSessionKey(SecretKey aSessionKey, PublicKey aPublicKey) {
        byte[] result = null;
        if (aSessionKey != null && aPublicKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                cipher.init(1, aPublicKey);
                byte[] encodedSessionKey = CKeyHelper.encodeSessionKey(aSessionKey);
                result = cipher.doFinal(encodedSessionKey);
            }
            catch (Exception e) {
                LOG_PREP.error((Throwable)e, "Error encrypting session key.");
                result = null;
            }
        }
        return result;
    }

    public static KeyPair getOrCreateMyRsaKey() {
        mKeyPair.compareAndSet(null, CKeyHelper.createRsaKey());
        return mKeyPair.get();
    }

    public static String getSessionKeyString(SecretKey aKey) {
        String result = "";
        if (aKey != null) {
            result = Base64.getEncoder().encodeToString(aKey.getEncoded());
        }
        return result;
    }
}

