/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.costs;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CCostEntry {
    private final UUID mConnectionId;
    private int mCostSum;
    private int mCostCount;
    private ZonedDateTime mTime;

    CCostEntry(@NotNull UUID aConnectionId) {
        this.mConnectionId = aConnectionId;
    }

    UUID getConnectionId() {
        return this.mConnectionId;
    }

    void addCosts(int aCosts) {
        this.mCostSum += aCosts;
        ++this.mCostCount;
        this.mTime = ZonedDateTime.now();
    }

    void reset() {
        this.mCostSum = 0;
        this.mCostCount = 0;
        this.mTime = ZonedDateTime.now();
    }

    int getAverage() {
        if (this.mCostCount > 0) {
            return this.mCostSum / this.mCostCount;
        }
        return 0;
    }

    int getRecordCount() {
        return this.mCostCount;
    }

    ZonedDateTime getTimeOfMeasurement() {
        return this.mTime;
    }
}

