/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.cli.display;

import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.impl.cli.display.CCliDisplayTarget;
import de.sillysky.nyssr.impl.cli.display.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.session.verifier.ISessionVerifier;
import org.jetbrains.annotations.NotNull;

public class CPackageImplCliDisplay
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INamespaceRegistry mNamespaceRegistry;
    private IRecordHelper mRecordHelper;
    private ISessionVerifier mSessionVerifier;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(INamespace.class, "nid=SYSTEM");
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(ICommandLineInterface.class);
        aDependencyList.add(ISessionVerifier.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceRegistry = (INamespaceRegistry)aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
            this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
            this.mSessionVerifier = (ISessionVerifier)aServiceRegistry.getServiceOrThrow(ISessionVerifier.class);
            this.mService = new CCliDisplayTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INamespaceRegistry getNamespaceRegistry() {
        return this.mNamespaceRegistry;
    }

    @Override
    @NotNull
    public IRecordHelper getRecordHelper() {
        return this.mRecordHelper;
    }

    @Override
    @NotNull
    public ISessionVerifier getSessionVerifier() {
        return this.mSessionVerifier;
    }
}

