/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.key;

import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class CUtilKeyCodes {
    private static final CIntegerToStringMap mKeyCodes = new CIntegerToStringMap("KeyCodes");

    public static CIntegerToStringMap getIntegerMap() {
        return mKeyCodes;
    }

    @NotNull
    public static List<String> getModifiers(int aModifiers) {
        ArrayList<String> modifiers = new ArrayList<String>();
        String s = InputEvent.getModifiersExText(aModifiers);
        if (CUtilString.isValid(s)) {
            StringTokenizer st = new StringTokenizer(s, "+", false);
            while (st.hasMoreElements()) {
                String e = (String)st.nextElement();
                if (!CUtilString.isValid(e)) continue;
                modifiers.add(s);
            }
        }
        return modifiers;
    }

    public static Collection<EKeyModifier> getActionModifiers(int aModifiers) {
        ArrayList<EKeyModifier> modifiers = new ArrayList<EKeyModifier>();
        if (CUtilKeyCodes.checkModifier(aModifiers, 1)) {
            modifiers.add(EKeyModifier.shift);
        }
        if (CUtilKeyCodes.checkModifier(aModifiers, 2)) {
            modifiers.add(EKeyModifier.ctrl);
        }
        if (CUtilKeyCodes.checkModifier(aModifiers, 8)) {
            modifiers.add(EKeyModifier.alt);
        }
        if (CUtilKeyCodes.checkModifier(aModifiers, 4)) {
            modifiers.add(EKeyModifier.meta);
        }
        return modifiers;
    }

    private static boolean checkModifier(int aModifier, int aMask) {
        return (aModifier & aMask) == aMask;
    }

    static {
        mKeyCodes.add("VK_ACCEPT", 30);
        mKeyCodes.add("VK_ADD", 107);
        mKeyCodes.add("VK_ACCEPT", 30);
        mKeyCodes.add("VK_ADD", 107);
        mKeyCodes.add("VK_AGAIN", 65481);
        mKeyCodes.add("VK_ALL_CANDIDATES", 256);
        mKeyCodes.add("VK_ALPHANUMERIC", 240);
        mKeyCodes.add("VK_ALT", 18);
        mKeyCodes.add("VK_ALT_GRAPH", 65406);
        mKeyCodes.add("VK_BACK_SPACE", 8);
        mKeyCodes.add("VK_BACK_QUOTE", 192);
        mKeyCodes.add("VK_CANCEL", 3);
        mKeyCodes.add("VK_CAPS_LOCK", 20);
        mKeyCodes.add("VK_CLEAR", 12);
        mKeyCodes.add("VK_CODE_INPUT", 258);
        mKeyCodes.add("VK_COMPOSE", 65312);
        mKeyCodes.add("VK_CONTEXT_MENU", 525);
        mKeyCodes.add("VK_CONTROL", 17);
        mKeyCodes.add("VK_CONVERT", 28);
        mKeyCodes.add("VK_COPY", 65485);
        mKeyCodes.add("VK_CUT", 65489);
        mKeyCodes.add("VK_DEAD_ABOVEDOT", 134);
        mKeyCodes.add("VK_DEAD_ABOVERING", 136);
        mKeyCodes.add("VK_DEAD_ACUTE", 129);
        mKeyCodes.add("VK_DEAD_BREVE", 133);
        mKeyCodes.add("VK_DEAD_CARON", 138);
        mKeyCodes.add("VK_DEAD_CEDILLA", 139);
        mKeyCodes.add("VK_DEAD_CIRCUMFLEX", 130);
        mKeyCodes.add("VK_DEAD_DIAERESIS", 135);
        mKeyCodes.add("VK_DEAD_DOUBLEACUTE", 137);
        mKeyCodes.add("VK_DEAD_GRAVE", 128);
        mKeyCodes.add("VK_DEAD_IOTA", 141);
        mKeyCodes.add("VK_DEAD_MACRON", 132);
        mKeyCodes.add("VK_DEAD_OGONEK", 140);
        mKeyCodes.add("VK_DEAD_SEMIVOICED_SOUND", 143);
        mKeyCodes.add("VK_DEAD_TILDE", 131);
        mKeyCodes.add("VK_DEAD_VOICED_SOUND", 142);
        mKeyCodes.add("VK_DELETE", 127);
        mKeyCodes.add("VK_KP_DOWN", 225);
        mKeyCodes.add("VK_DOWN", 40);
        mKeyCodes.add("VK_END", 35);
        mKeyCodes.add("VK_ENTER", 10);
        mKeyCodes.add("VK_ESCAPE", 27);
        mKeyCodes.add("VK_F", 70);
        mKeyCodes.add("VK_F1", 112);
        mKeyCodes.add("VK_F2", 113);
        mKeyCodes.add("VK_F3", 114);
        mKeyCodes.add("VK_F4", 115);
        mKeyCodes.add("VK_F5", 116);
        mKeyCodes.add("VK_F6", 117);
        mKeyCodes.add("VK_F7", 118);
        mKeyCodes.add("VK_F8", 119);
        mKeyCodes.add("VK_F9", 120);
        mKeyCodes.add("VK_F10", 121);
        mKeyCodes.add("VK_F11", 122);
        mKeyCodes.add("VK_F12", 123);
        mKeyCodes.add("VK_F13", 61440);
        mKeyCodes.add("VK_F14", 61441);
        mKeyCodes.add("VK_F15", 61442);
        mKeyCodes.add("VK_F16", 61443);
        mKeyCodes.add("VK_F17", 61444);
        mKeyCodes.add("VK_F18", 61445);
        mKeyCodes.add("VK_F19", 61446);
        mKeyCodes.add("VK_F20", 61447);
        mKeyCodes.add("VK_F21", 61448);
        mKeyCodes.add("VK_F22", 61449);
        mKeyCodes.add("VK_F23", 61450);
        mKeyCodes.add("VK_F24", 61451);
        mKeyCodes.add("VK_FINAL", 24);
        mKeyCodes.add("VK_FIND", 65488);
        mKeyCodes.add("VK_FULL_WIDTH", 243);
        mKeyCodes.add("VK_HALF_WIDTH", 244);
        mKeyCodes.add("VK_HELP", 156);
        mKeyCodes.add("VK_HIRAGANA", 242);
        mKeyCodes.add("VK_HOME", 36);
        mKeyCodes.add("VK_INPUT_METHOD_ON_OFF", 263);
        mKeyCodes.add("VK_INSERT", 155);
        mKeyCodes.add("VK_INVERTED_EXCLAMATION_MARK", 518);
        mKeyCodes.add("VK_JAPANESE_HIRAGANA", 260);
        mKeyCodes.add("VK_JAPANESE_KATAKANA", 259);
        mKeyCodes.add("VK_JAPANESE_ROMAN", 261);
        mKeyCodes.add("VK_KANA", 21);
        mKeyCodes.add("VK_KANA_LOCK", 262);
        mKeyCodes.add("VK_KANJI", 25);
        mKeyCodes.add("VK_KATAKANA", 241);
        mKeyCodes.add("VK_KP_DOWN", 225);
        mKeyCodes.add("VK_KP_LEFT", 226);
        mKeyCodes.add("VK_KP_RIGHT", 227);
        mKeyCodes.add("VK_KP_UP", 224);
        mKeyCodes.add("VK_LEFT", 37);
        mKeyCodes.add("VK_META", 157);
        mKeyCodes.add("VK_MODECHANGE", 31);
        mKeyCodes.add("VK_M", 77);
        mKeyCodes.add("VK_NONCONVERT", 29);
        mKeyCodes.add("VK_NUM_LOCK", 144);
        mKeyCodes.add("VK_PAGE_DOWN", 34);
        mKeyCodes.add("VK_PAGE_UP", 33);
        mKeyCodes.add("VK_PASTE", 65487);
        mKeyCodes.add("VK_PAUSE", 19);
        mKeyCodes.add("VK_PREVIOUS_CANDIDATE", 257);
        mKeyCodes.add("VK_PRINTSCREEN", 154);
        mKeyCodes.add("VK_PROPS", 65482);
        mKeyCodes.add("VK_RIGHT", 39);
        mKeyCodes.add("VK_ROMAN_CHARACTERS", 245);
        mKeyCodes.add("VK_SCROLL_LOCK", 145);
        mKeyCodes.add("VK_SEPARATER", 108);
        mKeyCodes.add("VK_SEPARATOR", 108);
        mKeyCodes.add("VK_SHIFT", 16);
        mKeyCodes.add("VK_SPACE", 32);
        mKeyCodes.add("VK_STOP", 65480);
        mKeyCodes.add("VK_TAB", 9);
        mKeyCodes.add("VK_UNDEFINED", 0);
        mKeyCodes.add("VK_UNDO", 65483);
        mKeyCodes.add("VK_UP", 38);
        mKeyCodes.add("VK_WINDOWS", 524);
    }
}

