/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.bytecarousel;

import de.sillysky.nyssr.util.bytecarousel.CByteCarousel;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

final class CByteCarouselInputStream
extends InputStream {
    private final CByteCarousel mParent;
    private boolean mClosed = false;

    CByteCarouselInputStream(CByteCarousel aByteCarousel) {
        this.mParent = aByteCarousel;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.mParent.getAvailableRead();
    }

    private void checkClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream already closed.");
        }
    }

    @Override
    public void close() {
        this.mClosed = true;
    }

    boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public synchronized void mark(int aLimit) {
        this.mParent.mark(aLimit);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.mParent.read();
    }

    @Override
    public int read(byte @NotNull [] aBuf) throws IOException {
        this.checkClosed();
        return this.mParent.read(aBuf, 0, aBuf.length);
    }

    @Override
    public int read(byte @NotNull [] aBuf, int aStartPos, int aBytesToRead) throws IOException {
        this.checkClosed();
        return this.mParent.read(aBuf, aStartPos, aBytesToRead);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.mParent.reset();
    }

    void reuse() {
        this.mClosed = false;
    }

    @Override
    public long skip(long aBytesToSkip) throws IOException {
        this.checkClosed();
        return this.mParent.skip(aBytesToSkip);
    }
}

