/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;
import java.util.UUID;

final class CStreamHeaderBasicEnvelope
extends CBasicStreamHeader<CEnvelope> {
    private static final int BIT_FIELD_BITS = 16;
    private static final int BIT_FIELD_BYTES = 2;
    private static final byte KNOWN_VERSION_0 = 0;
    private static final int BIT_IS_ANSWER = 0;
    private static final int BIT_LOG_ENABLED = 1;
    private static final int BIT_ONLY_LOCAL = 2;
    private static final int BIT_RESULT_CODE = 3;
    private static final int BIT_RESULT_TEXT = 4;
    private static final int BIT_HANDLED = 5;
    private static final int BIT_TRANSACTION_ID = 6;
    private static final int BIT_WANT_ANSWER = 7;
    private static final int BIT_HAS_PACKET_BUILDER_SEQUENCE = 8;
    private static final int BIT_IS_SERVICE_MESSAGE = 9;
    private static final int BIT_ROUTING_HINT = 10;
    private static final int BIT_MICROSERVICE_ID = 11;
    private static final int BIT_SESSION_TOKEN = 12;
    private static final int BILLION = 1000000000;
    private final ILogger LOG = CLoggerFactory.getLogger(CStreamHeaderBasicEnvelope.class);

    CStreamHeaderBasicEnvelope(CEnvelope aOwner) {
        super(1, aOwner, null);
    }

    CStreamHeaderBasicEnvelope(CEnvelope aOwner, byte[] aBytes) {
        super(1, aOwner, aBytes);
    }

    @Override
    public void pack() {
        if (this.getPackedData() != null) {
            return;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            CEnvelope env = (CEnvelope)this.getOwner();
            String packetBuilderSequence = env.getPacketBuilderSequence();
            byte version = env.getVersion();
            CTargetAddress sender = env.getSender();
            Stack<CTargetAddress> receivers = env.getReceivers();
            int resultCode = env.getResultCode();
            String resultText = env.getResultText();
            UUID transactionId = env.getTransactionId();
            CRoutingHint routingHint = env.getRoutingHint();
            IId microServiceId = env.getMicroServiceId();
            byte[] sessionToken = env.getSessionToken();
            CBitField bf = new CBitField(16);
            bf.set(0, env.isAnswer());
            bf.set(1, env.isLogEnabled());
            bf.set(2, env.isOnlyLocal());
            bf.set(5, env.hasBeenHandled());
            bf.set(3, resultCode != 0);
            bf.set(4, !resultText.isEmpty());
            bf.set(6, transactionId != null);
            bf.set(7, env.wantAnswer());
            bf.set(9, env.isNanoServiceMessage());
            bf.set(8, !CUtilString.isEmpty(packetBuilderSequence));
            bf.set(10, routingHint != null);
            bf.set(11, CIdFactory.isValid(microServiceId));
            bf.set(12, sessionToken != null);
            dos.writeByte(version);
            bf.toStreamWithoutLength(dos);
            CTargetAddress.toStream(dos, sender);
            CPositiveInteger.toStream(dos, receivers.size());
            for (CTargetAddress receiver : receivers) {
                CTargetAddress.toStream(dos, receiver);
            }
            if (bf.get(3)) {
                CPositiveInteger.toStream(dos, resultCode);
            }
            if (bf.get(4)) {
                CUtilString.toStream(dos, resultText);
            }
            if (bf.get(6)) {
                CUtilUuid.toStream(dos, transactionId);
            }
            if (bf.get(8)) {
                CUtilString.toStream(dos, packetBuilderSequence);
            }
            if (routingHint != null) {
                routingHint.toStream(dos);
            }
            if (bf.get(11) && microServiceId != null) {
                microServiceId.toStream(dos);
            }
            if (bf.get(12)) {
                CUtilByteArray.toStream(dos, sessionToken);
            }
            dos.writeInt(env.getInstanceId() % 1000000000);
            dos.close();
            byte[] result = bos.toByteArray();
            this.setPackedHeaderBytes(result);
        }
        catch (IOException aE) {
            this.LOG.error((Throwable)aE, "Error writing CEnvelope to Stream.");
            throw new RuntimeException(aE);
        }
    }

    @Override
    public void unpack() {
        byte[] packedData = this.getPackedData();
        if (packedData == null) {
            return;
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(packedData);
             DataInputStream dis = new DataInputStream(bis);){
            CEnvelope env = (CEnvelope)this.getOwner();
            byte version = dis.readByte();
            if (version == 0) {
                CBitField bf = new CBitField(16);
                bf.fromStream(dis, 2);
                env.setIsAnswer(bf.get(0));
                if (!bf.get(1)) {
                    env.setLogEnabled(false);
                }
                if (bf.get(2)) {
                    env.setOnlyLocal(true);
                }
                if (bf.get(5)) {
                    env.setHandled(true);
                }
                env.setWantAnswer(bf.get(7));
                if (bf.get(9)) {
                    env.setIsNanoServiceMessage(true);
                }
                CTargetAddress sender = CTargetAddress.fromStream(dis);
                env.setSender(sender);
                int amountOfReceivers = CPositiveInteger.fromStream(dis);
                for (int i = 0; i < amountOfReceivers; ++i) {
                    CTargetAddress receiver = CTargetAddress.fromStream(dis);
                    env.getReceivers().push(receiver);
                }
                int resultCode = bf.get(3) ? CPositiveInteger.fromStream(dis) : 0;
                String resultText = bf.get(4) ? CUtilString.fromStream(dis) : "";
                env.setResult(resultCode, resultText);
                if (bf.get(6)) {
                    UUID transactionId = CUtilUuid.fromStream(dis);
                    env.setTransactionId(transactionId);
                }
                if (bf.get(8)) {
                    String packetBuilderSequence = CUtilString.fromStream(dis);
                    env.setPacketBuilderSequence(packetBuilderSequence);
                }
                if (bf.get(10)) {
                    CRoutingHint hint = CRoutingHint.fromStream(dis);
                    env.setRoutingHint(hint);
                }
                if (bf.get(11)) {
                    IId microServiceId = CIdFactory.fromStream(dis, false);
                    env.setMicroServiceId(microServiceId);
                }
                if (bf.get(12)) {
                    byte[] sessionToken = CUtilByteArray.fromStream(dis);
                    env.setSessionToken(sessionToken);
                }
                int instanceId = dis.readInt() + 1000000000;
                env.setInstanceId(instanceId);
            }
        }
        catch (IOException aE) {
            this.LOG.error((Throwable)aE, "Error reading CEnvelope from Stream.");
            throw new RuntimeException(aE);
        }
    }
}

