/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class CEnvelopePrinter {
    private static final AtomicReference<INameDb> NAME_DB = new AtomicReference<Object>(null);
    private final CEnvelope mEnvelope;
    private final INameDb nameDb = NAME_DB.get();
    private final StringBuilder mSb = new StringBuilder(500);

    public CEnvelopePrinter(@NotNull CEnvelope aEnvelope) {
        this.mEnvelope = aEnvelope;
    }

    static void setNameDb(INameDb aNameDb) {
        NAME_DB.set(aNameDb);
    }

    private void newLine() {
        this.mSb.append(CUtilString.CRLF);
    }

    public String print() {
        this.printHeader();
        this.printMicroService();
        this.printSender();
        this.printReceiver();
        this.printBlocked();
        this.printWantAnswer();
        this.printAnswer();
        this.printTransactionId();
        this.printIsNanoServiceMessage();
        this.printInternalIds();
        return this.mSb.toString();
    }

    private void printInternalIds() {
        this.mSb.append("    Instance ID    = ");
        this.mSb.append(this.mEnvelope.getInstanceId());
        this.newLine();
        this.mSb.append("    Env ID         = ");
        this.mSb.append(this.mEnvelope.getEnvId());
        this.newLine();
    }

    private void printIsNanoServiceMessage() {
        if (this.mEnvelope.isNanoServiceMessage()) {
            this.mSb.append("    is Nano Service Message");
            this.newLine();
        }
    }

    private void printTransactionId() {
        UUID transactionId = this.mEnvelope.getTransactionId();
        if (transactionId != null) {
            this.mSb.append("    Transaction ID  = ");
            this.mSb.append(CUtilUuid.toShortString(transactionId));
            this.newLine();
        }
    }

    private void printAnswer() {
        if (this.mEnvelope.isAnswer()) {
            this.mSb.append("     Answer:");
            if (this.mEnvelope.hasBeenHandled()) {
                this.mSb.append(" Handled");
            }
            this.mSb.append(" RC=");
            this.mSb.append(this.mEnvelope.getResultCode());
            this.mSb.append(" RT=");
            this.mSb.append(this.mEnvelope.getResultText());
            this.newLine();
        }
    }

    private void printWantAnswer() {
        if (this.mEnvelope.wantAnswer()) {
            this.mSb.append("    WantAnswer");
            this.newLine();
        }
    }

    private void printBlocked() {
        if (this.mEnvelope.isBlocked()) {
            this.mSb.append("    Blocked");
            this.newLine();
        }
    }

    private void printMicroService() {
        IId microServiceId = this.mEnvelope.getMicroServiceId();
        if (microServiceId != null) {
            this.mSb.append("    MicroServiceId = ");
            this.mSb.append(microServiceId);
            this.newLine();
        }
    }

    private void printReceiver() {
        CTargetAddress receiver = this.mEnvelope.getReceiver();
        CTargetAddress sender = this.mEnvelope.getSender();
        this.mSb.append("    Receiver       = ");
        boolean self = true;
        IId rTID = receiver.getTID();
        IId rNID = receiver.getNID();
        CNodeId rNodeId = receiver.getNodeId();
        if (!CIdFactory.equals(sender.getTID(), rTID)) {
            self = false;
        }
        if (!CIdFactory.equals(sender.getNID(), rNID)) {
            self = false;
        }
        if (!CNodeId.equals(sender.getNodeId(), rNodeId)) {
            self = false;
        }
        if (self) {
            this.mSb.append("self");
        } else {
            this.printTargetAddress(receiver);
        }
        this.newLine();
    }

    private void printTargetAddress(CTargetAddress aReceiver) {
        String nameReceiver;
        this.mSb.append(aReceiver);
        if (this.nameDb != null && (nameReceiver = this.nameDb.getTargetAddressDatabase().getNameOrNull(aReceiver)) != null) {
            this.mSb.append(" (");
            this.mSb.append(nameReceiver);
            this.mSb.append(")");
        }
    }

    private void printSender() {
        CTargetAddress sender = this.mEnvelope.getSender();
        this.mSb.append("    Sender         = ");
        this.printTargetAddress(sender);
        this.newLine();
    }

    private void printHeader() {
        this.mSb.append("Envelope ");
        if (this.mEnvelope.isAnswer()) {
            this.mSb.append("Answer");
        } else {
            this.mSb.append("Request");
        }
        this.newLine();
    }
}

