/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.thread;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.thread.IThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

final class CThreadFactory
implements IThreadFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CThreadFactory.class);
    private final AtomicReference<ScheduledExecutorService> mScheduledExecutorService = new AtomicReference();

    CThreadFactory() {
    }

    @Override
    public ScheduledExecutorService getScheduledThreadPool() {
        ScheduledExecutorService service;
        do {
            if ((service = this.mScheduledExecutorService.get()) == null) continue;
            return service;
        } while (!this.mScheduledExecutorService.compareAndSet(null, service = Executors.newScheduledThreadPool(1)));
        LOG.info("Thread pool allocated.");
        return service;
    }
}

