/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.impl.util.CJsonMessageUtil;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotMessage
implements ISlot,
ISingleSlotTypeFactory {
    private final CMessage mValue;

    public CSlotMessage() {
        this.mValue = null;
    }

    private CSlotMessage(CMessage aValue) {
        this.mValue = aValue;
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        CSlotMessage result = null;
        if (this.getType().equals(aType)) {
            if (aValue == null) {
                result = new CSlotMessage();
            } else if (aValue instanceof CMessage) {
                result = new CSlotMessage((CMessage)aValue);
            } else if (aValue instanceof String || aValue instanceof List) {
                // empty if block
            }
        }
        return result;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CMessage message = CJsonMessageUtil.fromJson(aValue, aByteArrayStore);
        if (message != null) {
            return new CSlotMessage(message);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotMessage other = (CSlotMessage)aObj;
        if (this.mValue == null) {
            return other.mValue == null;
        }
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CMessage.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        if (this.mValue != null) {
            CMessage msg = new CMessage(this.mValue);
            return new CSlotMessage(msg);
        }
        return new CSlotMessage();
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.MESSAGE;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mValue == null ? 0 : this.mValue.hashCode());
        return result;
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        if (aValue == null) {
            return this.mValue == null;
        }
        if (this.mValue != null) {
            return this.mValue.equals(aValue);
        }
        return false;
    }

    @Override
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        CSlotMessage result = null;
        if (this.getType().equals(aType)) {
            byte exist = aStream.readByte();
            if (exist == 0) {
                result = new CSlotMessage();
            } else {
                CMessage value = CMessage.fromStream(aStream);
                result = new CSlotMessage(value);
            }
        }
        return result;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        if (this.mValue == null) {
            aStream.writeByte(0);
        } else {
            aStream.writeByte(1);
            this.mValue.toStream(aStream);
        }
    }

    @NotNull
    public String toString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (this.mValue != null) {
            return CJsonMessageUtil.toJson(this.mValue, aByteArrayStore);
        }
        return null;
    }
}

