/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.registry.helper;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.namespace.registry.INamespaceListener;
import de.sillysky.nyssr.impl.record.registry.helper.CGeneratedRecord;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.record.IRecordRegistryHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public final class CRecordRegistryHelper
implements IRecordRegistryHelper,
INamespaceListener,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordRegistryHelper.class);
    private final Map<IId, CGeneratedRecord> mGeneratedRecords = new ConcurrentHashMap<IId, CGeneratedRecord>();
    private final Map<IId, Set<IId>> mServicesInNamespaces = new ConcurrentHashMap<IId, Set<IId>>();
    private final Set<IId> mServicesForAllNamespaces = new CopyOnWriteArraySet<IId>();
    private final Set<CGeneratedRecord> mNonServices = new HashSet<CGeneratedRecord>();
    private INameDb mNameDb;
    private INamespaceRegistry mNamespaceRegistry;

    public static void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(INamespaceRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        this.mNameDb = aServiceRegistry.getService(INameDb.class);
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        assert (this.mNamespaceRegistry != null);
        this.mNamespaceRegistry.addListener(this);
        Set<CGeneratedRecord> set = this.mNonServices;
        synchronized (set) {
            this.mNonServices.removeIf(this::registerNonService);
        }
        for (CGeneratedRecord s : this.mGeneratedRecords.values()) {
            this.registerServices(s);
        }
        aServiceRegistry.registerService(IRecordRegistryHelper.class, this);
    }

    private void add(@NotNull IId aNID, @NotNull IId aSID) {
        Set<IId> set = this.mServicesInNamespaces.get(aNID);
        if (set == null) {
            set = new CopyOnWriteArraySet<IId>();
            this.mServicesInNamespaces.put(aNID, set);
        }
        set.add(aSID);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        INamespaceRegistry nr = aServiceRegistry.getService(INamespaceRegistry.class);
        if (nr != null) {
            nr.removeListener(this);
        }
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void deregisterRecord(@NotNull Class<? extends IGeneratedRecord> aClass) {
    }

    private boolean hasAll(String[] aNamespaceIdNames) {
        boolean all = false;
        for (String s : aNamespaceIdNames) {
            if (!"*".equals(s)) continue;
            all = true;
            break;
        }
        return all;
    }

    @Override
    public void notifyNamespaceDeregistered(@NotNull IId aNID) {
    }

    @Override
    public void notifyNamespaceRegistered(@NotNull IId aNID) throws Exception {
        INamespace n = this.mNamespaceRegistry.getNamespace(aNID);
        if (n != null) {
            CGeneratedRecord s;
            INanoServiceRegistry sr = n.getNanoServiceRegistry();
            Set<IId> set = this.mServicesInNamespaces.get(aNID);
            if (set != null && !set.isEmpty()) {
                for (IId sid : set) {
                    s = this.mGeneratedRecords.get(sid);
                    if (s == null) continue;
                    sr.addNanoService(s.getSID(), s.getName());
                }
            }
            for (IId sid : this.mServicesForAllNamespaces) {
                s = this.mGeneratedRecords.get(sid);
                if (s == null) continue;
                sr.addNanoService(sid, s.getName());
            }
        }
    }

    private boolean registerNonService(@NotNull CGeneratedRecord aService) {
        if (this.mNameDb != null) {
            this.mNameDb.getRecordIdDatabase().putName(aService.getSID(), aService.getName());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRecord(@NotNull Class<? extends IGeneratedRecord> aGeneratedClass) throws CException {
        try {
            CGeneratedRecord record;
            Field f = aGeneratedClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            f = aGeneratedClass.getDeclaredField("NAMESPACES");
            String[] namespaceNames = (String[])f.get(null);
            f = aGeneratedClass.getDeclaredField("NAME");
            String name = (String)f.get(null);
            if (namespaceNames.length == 0) {
                if (this.mNameDb != null) {
                    this.mNameDb.getRecordIdDatabase().putName(id, name);
                } else {
                    Set<CGeneratedRecord> set = this.mNonServices;
                    synchronized (set) {
                        this.mNonServices.add(new CGeneratedRecord(id, name));
                    }
                }
                return;
            }
            boolean all = this.hasAll(namespaceNames);
            if (all) {
                record = new CGeneratedRecord(id, name);
                this.mServicesForAllNamespaces.add(id);
            } else {
                HashSet<IId> namespaceIDs = new HashSet<IId>();
                for (String s : namespaceNames) {
                    IId nid = CIdFactory.fromObject(s);
                    namespaceIDs.add(nid);
                    this.add(nid, id);
                }
                IId[] arr = new IId[namespaceIDs.size()];
                arr = namespaceIDs.toArray(arr);
                record = new CGeneratedRecord(id, name, arr);
            }
            this.mGeneratedRecords.put(id, record);
            this.registerServices(record);
        }
        catch (Exception e) {
            LOG.error(e, "Couldn't register NanoService {}.", aGeneratedClass.getName());
            throw new CException(29).append(e.getMessage());
        }
    }

    private void registerServices(@NotNull CGeneratedRecord aService) throws CException {
        block5: {
            if (this.mNamespaceRegistry == null) {
                this.mNamespaceRegistry = CServiceRegistry.getInstance().getService(INamespaceRegistry.class);
            }
            if (this.mNamespaceRegistry == null) break block5;
            if (aService.isForAllNamespaces()) {
                INamespace[] namespaces2;
                for (INamespace n : namespaces2 = this.mNamespaceRegistry.getNamespaces()) {
                    INanoServiceRegistry sr = n.getNanoServiceRegistry();
                    sr.addNanoService(aService.getSID(), aService.getName());
                }
            } else {
                for (IId nid : aService.getNamespaceIDs()) {
                    INamespace n = this.mNamespaceRegistry.getNamespace(nid);
                    if (n == null) continue;
                    INanoServiceRegistry sr = n.getNanoServiceRegistry();
                    sr.addNanoService(aService.getSID(), aService.getName());
                }
            }
        }
    }
}

