/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.plugin.CClassLoader;
import de.sillysky.nyssr.impl.plugin.CPlugInEntry;
import de.sillysky.nyssr.impl.plugin.CPlugInList;
import de.sillysky.nyssr.impl.plugin.CUtilPlugIn;
import de.sillysky.nyssr.impl.plugin.IDependencies;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.plugin.IPlugIn;
import de.sillysky.nyssr.plugin.IPlugInEntry;
import de.sillysky.nyssr.plugin.IPlugInManager;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import de.sillysky.nyssr.util.version.CVersion;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CPlugInManager
implements IPlugInManager,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPlugInManager.class);
    private static final String EXTENSION = ".jar";
    private CPlugInList mPlugInList;
    private CClassLoader mLoader;
    private Path mPlugInDirectory;
    private final IDependencies mDependencies;

    public CPlugInManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        Path path;
        IKernelConfiguration kernelConfiguration = this.mDependencies.getKernelConfiguration();
        this.mPlugInList = new CPlugInList(CNodeAddress.getLocal());
        Preferences preferences = kernelConfiguration.getPreferences("kernel.configuration");
        String pluginDir = preferences.get("plugin.dir", null);
        if (pluginDir != null) {
            path = Paths.get(pluginDir, new String[0]);
        } else {
            String s = preferences.get("base.dir", ".");
            path = Paths.get(s, "plugins");
        }
        this.mPlugInDirectory = path.toAbsolutePath().normalize();
        this.mDependencies.getNodeStringProperties().set("path.plugins", this.mPlugInDirectory.toString());
        this.load();
        aServiceRegistry.registerService(IPlugInManager.class, this);
    }

    @NotNull
    private CClassLoader createClassLoader(@Nullable File aPlugInDir) throws CException, URISyntaxException {
        Path jarPath = this.mDependencies.getKernelConfiguration().getPathOfLibraries();
        ClassLoader parentLoader = this.getClass().getClassLoader();
        CClassLoader loader = new CClassLoader(new URL[0], parentLoader);
        loader.addDirectory(jarPath.toFile());
        return loader;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
        this.unload();
    }

    @Nullable
    private File getFileWithBiggerVersion(@NotNull List<File> aFiles) {
        CVersion best = null;
        for (File f : aFiles) {
            CVersion v = CVersion.fromFile(f);
            if (best != null && best.compareTo(v) >= 0) continue;
            best = v;
        }
        return best == null ? null : (File)best.getData();
    }

    @NotNull
    private List<File> getFiles(@NotNull File aDir) throws CException {
        if (!aDir.isDirectory()) {
            throw new CException(2212).append("Argument is no Directory.");
        }
        LOG.info("Load Plugins from {}.", aDir.getAbsolutePath());
        File[] files = aDir.listFiles((dir, name) -> name.toLowerCase().contains(EXTENSION));
        if (files != null) {
            return Arrays.asList(files);
        }
        return new ArrayList<File>();
    }

    @NotNull
    private List<File> getListOfJarsWithThisName(@NotNull List<File> aFileList, @NotNull String aName) {
        ArrayList<File> list = new ArrayList<File>();
        for (File f : aFileList) {
            if (!f.getName().startsWith(aName)) continue;
            list.add(f);
        }
        return list;
    }

    @NotNull
    private File getPlugInDir() {
        File file = this.mPlugInDirectory.toFile();
        CUtilCheck.checkTrue(file.exists(), "plugin.dir not existing: %s", this.mPlugInDirectory);
        return file;
    }

    @Override
    @NotNull
    public Collection<IPlugInEntry> getPlugIns() {
        ArrayList<IPlugInEntry> list = new ArrayList<IPlugInEntry>();
        for (IPlugInEntry e : this.mPlugInList) {
            list.add(e);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private String getPluginClass(@NotNull File aFile) throws CException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load() throws CException, URISyntaxException {
        File plugInDir = this.getPlugInDir();
        this.mLoader = this.createClassLoader(plugInDir);
        List<File> files = this.getFiles(plugInDir);
        List<String> pluginList = CUtilPlugIn.loadPluginListFromPreferencesSubNode();
        if (pluginList.isEmpty()) {
            LOG.info("No PlugIns to load.");
            return;
        }
        this.loadPlugIns(this.mLoader, files, pluginList);
    }

    @NotNull
    private CPlugInEntry loadPlugIn(@NotNull CClassLoader aLoader, @NotNull File aFile) throws CException {
        CPlugInEntry pe = new CPlugInEntry(aFile);
        String jarName = aFile.getName();
        LOG.info("Start: load plugin {}.", jarName);
        String className = this.getPluginClass(aFile);
        this.prepareClassLoader(pe, aLoader, aFile, className);
        LocalDateTime startTime0 = this.mDependencies.getKernelConfiguration().getStartTime();
        long startTime = CUtilLocalDateTime.getLocalMillis(startTime0);
        pe.setStartResult(System.currentTimeMillis() - startTime, null);
        LOG.info("Okay: plugin {} started.", jarName);
        return pe;
    }

    private void loadPlugIns(@NotNull CClassLoader aLoader, @NotNull List<File> aFileList, @NotNull List<String> aOrderList) {
        for (String name : aOrderList) {
            try {
                File f;
                CPlugInEntry pe = null;
                List<File> filesStartsWith = this.getListOfJarsWithThisName(aFileList, name);
                int size = filesStartsWith.size();
                if (size == 1) {
                    pe = this.loadPlugIn(aLoader, filesStartsWith.get(0));
                } else if (size > 1 && (f = this.getFileWithBiggerVersion(filesStartsWith)) != null) {
                    pe = this.loadPlugIn(aLoader, f);
                }
                if (pe != null) {
                    this.mPlugInList.add(pe);
                    continue;
                }
                LOG.error("No PlugIn {} found", name);
            }
            catch (CException e) {
                LOG.error(e, "Couldn't load plugIn {}: {}", name, e.getMessage());
            }
        }
    }

    private void prepareClassLoader(@NotNull CPlugInEntry aEntry, @NotNull CClassLoader aLoader, @NotNull File aFile, @NotNull String aClassName) throws CException {
        try {
            URL jarUrl = aFile.toURI().toURL();
            aLoader.addURL(jarUrl);
            aEntry.setURL(jarUrl);
            Class<?> theClass = Class.forName(aClassName, true, this.mLoader);
            CUtilCheck.checkNotNull(theClass, "PlugIn Class %s does not exist in the manifest of %s", aClassName, aFile.toString());
            aEntry.setPlugInClass(theClass);
            Class<IPlugIn> plugClass = theClass.asSubclass(IPlugIn.class);
            Constructor<IPlugIn> plugConstructor = plugClass.getConstructor(new Class[0]);
            IPlugIn plugInstance = plugConstructor.newInstance(new Object[0]);
            plugInstance.startPlugin(jarUrl, aLoader, CServiceRegistry.getInstance());
        }
        catch (Throwable e) {
            throw new CException(2).append(e);
        }
    }

    private void unload() {
    }
}

