/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.plugin.CPlugInEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CPlugInList
implements Iterable<CPlugInEntry> {
    private final List<CPlugInEntry> mList = new ArrayList<CPlugInEntry>();
    private final CNodeAddress mNodeAddress;

    CPlugInList(CNodeAddress aNodeAddress) {
        this.mNodeAddress = aNodeAddress;
    }

    void add(CPlugInEntry aPlugIn) {
        this.mList.add(aPlugIn);
    }

    @Nullable
    public CPlugInEntry find(@NotNull String aString) {
        for (CPlugInEntry e : this.mList) {
            if (!e.getName().contains(aString)) continue;
            return e;
        }
        return null;
    }

    private int getLoadedSize() {
        int number = 0;
        for (CPlugInEntry e : this.mList) {
            if (!e.hasSuccess()) continue;
            ++number;
        }
        return number;
    }

    @NotNull
    private String getLoadedString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (CPlugInEntry e : this.mList) {
            if (!e.hasSuccess()) continue;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(e.getName());
            ++i;
        }
        return sb.toString();
    }

    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    @Override
    @NotNull
    public Iterator<CPlugInEntry> iterator() {
        return this.mList.iterator();
    }

    public int size() {
        return this.mList.size();
    }

    @NotNull
    public String toString() {
        return this.mNodeAddress + "(" + this.getLoadedSize() + " Plugins): " + this.getLoadedString();
    }
}

