/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namedb;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.IRecordIdDatabase;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class CRecordIdDatabase
implements IRecordIdDatabase {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordIdDatabase.class);
    private static final int MAP_SIZE = 500;
    private final Map<IId, String> mDb = new ConcurrentHashMap<IId, String>(500);

    CRecordIdDatabase() {
    }

    @Override
    public void dump() {
        LOG.info("CRecordIdDatabase: size={}", this.mDb.size());
        for (Map.Entry<IId, String> entry : this.mDb.entrySet()) {
            LOG.trace("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public String getName(@NotNull IId aMessageId) {
        String name = this.mDb.get(aMessageId);
        String asString = aMessageId.valueToString();
        String result = name == null ? asString : asString + " (" + name + ")";
        return result;
    }

    @Override
    public String getNameOrNull(@NotNull IId aMessageId) {
        return this.mDb.get(aMessageId);
    }

    @Override
    public void putName(@NotNull IId aMessageId, @NotNull String aName) {
        this.mDb.put(aMessageId, aName);
    }

    @Override
    public void removeName(@NotNull IId aMessageId) {
        this.mDb.remove(aMessageId);
    }
}

