/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.file.reader;

import de.sillysky.nyssr.configuration.files.IConfigFileReader;
import de.sillysky.nyssr.impl.kernel.config.file.reader.CPathComparator;
import de.sillysky.nyssr.impl.kernel.config.file.reader.IConfigValueHandler;
import de.sillysky.nyssr.impl.kernel.config.file.reader.IDependencies;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.CUtilPropertyReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CConfigFileReader
implements IService,
IConfigFileReader {
    private static final String EXT = ".cfg";
    private static final int EXT_LENGTH = ".cfg".length();
    private final List<Path> mConfigFileList = new ArrayList<Path>();
    private final IDependencies mDependencies;

    CConfigFileReader(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.registerService(IConfigFileReader.class, this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void readConfigFiles(@NotNull Path aPath, @NotNull IConfigValueHandler aValueHandler) throws IOException {
        try (Stream<Path> list = Files.list(aPath);){
            list.sorted(new CPathComparator()).forEach(path -> this.readFile((Path)path, aValueHandler));
        }
    }

    private void readFile(@NotNull Path aPath, @NotNull IConfigValueHandler aValueHandler) {
        File file = aPath.toFile();
        String name = file.getName();
        String lowerName = name.toLowerCase();
        if (lowerName.endsWith(EXT)) {
            this.mConfigFileList.add(aPath);
            CStringProperties properties = CUtilPropertyReader.readStringProperties(file);
            name = name.substring(0, name.length() - EXT_LENGTH);
            String nodePath = properties.remove("preference.node.name");
            if (CUtilString.isEmpty(nodePath)) {
                nodePath = name;
            }
            this.mDependencies.getNodeStringProperties().set("configuration.file." + nodePath, aPath.toString());
            Preferences pref = aValueHandler.getPreferences(nodePath);
            String s = properties.remove("preference.node.clear.first");
            boolean clearNodeFirst = CUtilBoolean.fromString(s, false);
            if (clearNodeFirst) {
                aValueHandler.removeAllKeysFromPreferenceNode(pref);
            }
            s = properties.remove("preference.key.overwrite.existing");
            boolean overwrite = CUtilBoolean.fromString(s, true);
            Collection<String> keys = properties.getKeys();
            for (String key : keys) {
                String value = properties.get(key);
                if (!overwrite) {
                    String oldValue = pref.get(key, null);
                    if (oldValue != null) continue;
                    aValueHandler.handleProperty(nodePath, key, value);
                    continue;
                }
                aValueHandler.handleProperty(nodePath, key, value);
            }
        }
    }

    @Override
    @NotNull
    public List<Path> getConfigFiles() {
        return new ArrayList<Path>(this.mConfigFileList);
    }

    @Override
    public void notifyFileDeleted(@NotNull Path aPath) {
        this.mConfigFileList.remove(aPath);
    }
}

