/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.uuid;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CIdUuid
implements IId {
    private static final int MAX_LEN = 30;
    private final UUID mValue;
    private final int mHashCode;
    private final boolean mValid;
    private String mLongString;
    private String mShortString;

    CIdUuid() {
        this.mValue = UUID.randomUUID();
        this.mValid = true;
        this.mHashCode = 911 + this.mValue.hashCode();
    }

    CIdUuid(@Nullable UUID aID) {
        if (aID == null) {
            this.mValue = CUtilUuid.UUID_INVALID;
            this.mValid = false;
        } else {
            this.mValue = aID;
            this.mValid = !CUtilUuid.isEmpty(this.mValue);
        }
        this.mHashCode = 911 + this.mValue.hashCode();
    }

    @Override
    public int compareTo(@NotNull IId aOther) {
        return CIdFactory.compareTo(this, aOther);
    }

    private void createStrings() {
        if (this.mLongString == null) {
            this.mLongString = this.mValue.toString();
            this.mShortString = this.mLongString.substring(30);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIdUuid other = (CIdUuid)obj;
        return this.mValue.equals(other.mValue);
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.UUID;
    }

    public UUID getUUID() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        this.createStrings();
        return this.mHashCode;
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }

    @Override
    @NotNull
    public String toShortString() {
        return CUtilUuid.isValid(this.mValue) ? this.mShortString : "";
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        byte b = this.getType().getValue();
        aStream.writeByte(b);
        CUtilUuid.nonNullToStream(aStream, this.mValue);
    }

    public String toString() {
        this.createStrings();
        return this.mShortString;
    }

    @Override
    @NotNull
    public String valueToString() {
        this.createStrings();
        return CUtilUuid.isValid(this.mValue) ? this.mLongString : "";
    }
}

