/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.integer;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CPositiveInteger;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CIdInteger
implements IId {
    private final int mValue;

    CIdInteger(int aID) {
        this.mValue = aID;
    }

    @Override
    public int compareTo(@NotNull IId aOther) {
        return CIdFactory.compareTo(this, aOther);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CIdInteger other = (CIdInteger)aObj;
        return this.mValue == other.mValue;
    }

    public int getInt() {
        return this.mValue;
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.INT;
    }

    @Override
    public int hashCode() {
        return 911 + this.mValue;
    }

    @Override
    public boolean isValid() {
        return this.mValue != 0;
    }

    @Override
    @NotNull
    public String toShortString() {
        return this.valueToString();
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        byte b = this.getType().getValue();
        aStream.writeByte(b);
        CPositiveInteger.toStream(aStream, this.mValue);
    }

    public String toString() {
        return this.valueToString();
    }

    @Override
    @NotNull
    public String valueToString() {
        return Integer.toString(this.mValue);
    }
}

