/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.util.swing.color.CNamedColor;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Color;
import java.util.Map;

public final class CStringToColor
implements IConverter<String, Color> {
    @Override
    public Color convertTo(String aObj, Map<String, Object> aConstraints) {
        if (aObj == null || aObj.trim().isEmpty()) {
            return null;
        }
        String s = aObj.trim();
        if (s.isEmpty()) {
            return null;
        }
        String[] split = s.split(",");
        if (split.length == 1) {
            String s0 = split[0].trim();
            CNamedColor color = CNamedColors.get(s0);
            if (color != null) {
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            }
        } else if (split.length == 2) {
            String s0 = split[0].trim();
            CNamedColor color = CNamedColors.get(s0);
            if (color != null) {
                return color.getColor(Integer.parseInt(split[1].trim()));
            }
        } else {
            if (split.length == 3) {
                return new Color(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()), 255);
            }
            if (split.length == 4) {
                return new Color(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()), Integer.parseInt(split[3].trim()));
            }
        }
        return null;
    }

    @Override
    public Class<?> getDestinationClass() {
        return Color.class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
    }
}

