/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.util.CUtilByte;
import java.util.Collection;
import java.util.Map;

public final class CStringToByteArray
implements IConverter<String, Byte[]> {
    private IConverterRegistry mRegistry;

    private Byte[] convertFromList(String aStr, Map<String, Object> aConstraints) {
        if (aStr == null || aStr.isEmpty()) {
            return null;
        }
        Collection coll = this.mRegistry.convert(String.class, "", Collection.class, "", aStr, aConstraints);
        if (coll == null) {
            return null;
        }
        Byte[] bb = new Byte[coll.size()];
        int i = 0;
        for (String s : coll) {
            if (s == null) {
                bb[i++] = null;
                continue;
            }
            bb[i++] = CUtilByte.fromObject(s, (byte)0);
        }
        return bb;
    }

    @Override
    public Byte[] convertTo(String aStr, Map<String, Object> aConstraints) {
        return this.convertFromList(aStr, aConstraints);
    }

    @Override
    public Class<?> getDestinationClass() {
        return Byte[].class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
        this.mRegistry = aRegistry;
    }
}

