/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.session.api;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.api.CRight;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRightList {
    private final TreeSet<CRight> mRights = new TreeSet();

    @Contract(value="_ -> new")
    @NotNull
    public static CRightList fromRecordArray(@Nullable CRecord[] aRecords) throws CException {
        if (aRecords == null) {
            return new CRightList();
        }
        ArrayList<CRight> list = new ArrayList<CRight>();
        for (CRecord record : aRecords) {
            if (record == null) continue;
            CRight right = CRight.fromRecord(record);
            list.add(right);
        }
        return new CRightList(list);
    }

    @NotNull
    public static CRightList fromStream(@NotNull DataInputStream aStream) throws IOException, CException {
        CRightList list = new CRightList();
        int count = aStream.readShort();
        for (int i = 0; i < count; ++i) {
            list.add(CRight.fromStream(aStream));
        }
        return list;
    }

    public CRightList(@NotNull Collection<CRight> aRights) {
        this.mRights.addAll(aRights);
    }

    public CRightList() {
    }

    public Collection<CRight> getRights() {
        return this.mRights;
    }

    public void add(@NotNull CRight aRight) {
        this.mRights.add(aRight);
    }

    public CRecord[] toRecordArray() throws CException {
        CRecord[] records = new CRecord[this.mRights.size()];
        int i = 0;
        for (CRight right : this.mRights) {
            records[i++] = right.toRecord();
        }
        return records;
    }

    public boolean hasRight(@NotNull String aRight) {
        for (CRight right : this.mRights) {
            if (!right.getId().equals(aRight)) continue;
            return true;
        }
        return false;
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        aStream.writeShort(this.mRights.size());
        for (CRight right : this.mRights) {
            right.toStream(aStream);
        }
    }

    public boolean isEmpty() {
        return this.mRights.isEmpty();
    }

    @NotNull
    public String[] toRightIdArray() {
        String[] rightIds = new String[this.mRights.size()];
        int i = 0;
        for (CRight right : this.mRights) {
            rightIds[i++] = right.getId();
        }
        return rightIds;
    }
}

