/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.point;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.arguments.CArgumentList;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilPoint {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String COLON = ",";
    public static final String EQUAL = "=";
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilPoint.class);

    private CUtilPoint() {
    }

    @Nullable
    public static Point parse(@NotNull Object aValue, @Nullable Point aDefault) {
        return aDefault;
    }

    @Nullable
    public static Point parse(@NotNull String aStr, @Nullable Point aDefault) {
        if (aStr.indexOf(EQUAL) > 0) {
            CStringProperties prop = new CArgumentList().toLower().split(aStr).parseProperties(0, EQUAL);
            return CUtilPoint.parse(prop, aDefault);
        }
        String[] split = aStr.split(COLON);
        if (split.length >= 2) {
            int x = CUtilInteger.fromString(split[0], aDefault == null ? 0 : aDefault.x);
            int y = CUtilInteger.fromString(split[1], aDefault == null ? 0 : aDefault.y);
            return new Point(x, y);
        }
        LOG.error("Invalid format for Point: {}", aStr);
        return null;
    }

    @NotNull
    public static Point parse(@NotNull CStringProperties aValue, @Nullable Point aDefault) {
        String s1 = aValue.get(X, null);
        int x = CUtilInteger.fromString(s1, aDefault == null ? 0 : aDefault.x);
        String s2 = aValue.get(Y, null);
        int y = CUtilInteger.fromString(s2, aDefault == null ? 0 : aDefault.y);
        return new Point(x, y);
    }
}

