/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CStringProperty {
    private static final String DELIMITER = "=";
    private final String mKey;
    private final String mValue;

    public CStringProperty(@NotNull CStringProperty aOther) {
        this.mKey = aOther.mKey;
        this.mValue = aOther.mValue;
    }

    public CStringProperty(@NotNull String aCombined) throws CException {
        String[] split = aCombined.split(DELIMITER);
        if (split.length == 2) {
            this.mKey = split[0].trim();
            this.mValue = split[1].trim();
        } else if (split.length == 1) {
            this.mKey = split[0].trim();
            this.mValue = "";
        } else {
            this.mKey = "";
            this.mValue = "";
        }
        if (CUtilString.isEmpty(this.mKey)) {
            throw new CException(7).append("Key is empty");
        }
    }

    public CStringProperty(@NotNull String aKey, @NotNull String aValue) {
        this.mKey = CUtilString.isEmpty(aKey) ? "Unknown" : aKey;
        this.mValue = aValue;
    }

    @NotNull
    public static CStringProperty fromStream(@NotNull DataInput aStream) throws IOException {
        String key = aStream.readUTF();
        String value = aStream.readUTF();
        return new CStringProperty(key, value);
    }

    @NotNull
    public static CStringProperty random() {
        return new CStringProperty(CUtilString.random(10), CUtilString.random(10));
    }

    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CStringProperty other = (CStringProperty)aObj;
        return Objects.equals(this.mKey, other.mKey) && Objects.equals(this.mValue, other.mValue);
    }

    @NotNull
    public String getKey() {
        return this.mKey;
    }

    @NotNull
    public String getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return Objects.hash(this.mKey, this.mValue);
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeUTF(this.mKey);
        aStream.writeUTF(this.mValue);
    }

    public void valueToList(@NotNull List<String> aList) {
        String s = this.valueToString();
        aList.add(s);
    }

    @NotNull
    public String valueToString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.mKey);
        sb.append(DELIMITER);
        if (CUtilString.isValid(this.mValue)) {
            sb.append(this.mValue);
        }
        return sb.toString();
    }

    @NotNull
    public String toString() {
        return this.mKey + DELIMITER + this.mValue;
    }
}

