/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;

public final class CStreamHelper {
    private final ByteArrayOutputStream mBaos = new ByteArrayOutputStream();
    private final DataOutputStream mDos = new DataOutputStream(this.mBaos);

    public CStreamHelper append(boolean aValue) throws IOException {
        this.mDos.writeBoolean(aValue);
        return this;
    }

    public CStreamHelper append(byte aValue) throws IOException {
        this.mDos.writeByte(aValue);
        return this;
    }

    public CStreamHelper append(byte[] aValue) throws IOException {
        CUtilByteArray.toStream(this.mDos, aValue);
        return this;
    }

    public CStreamHelper append(char aValue) throws IOException {
        this.mDos.writeChar(aValue);
        return this;
    }

    public CStreamHelper append(double aValue) throws IOException {
        this.mDos.writeDouble(aValue);
        return this;
    }

    public CStreamHelper append(float aValue) throws IOException {
        this.mDos.writeFloat(aValue);
        return this;
    }

    public CStreamHelper append(int aValue) throws IOException {
        this.mDos.writeInt(aValue);
        return this;
    }

    public CStreamHelper append(long aValue) throws IOException {
        this.mDos.writeLong(aValue);
        return this;
    }

    public CStreamHelper append(short aValue) throws IOException {
        this.mDos.writeShort(aValue);
        return this;
    }

    public CStreamHelper append(String aValue) throws IOException {
        CUtilString.toStream(this.mDos, aValue);
        return this;
    }

    public CStreamHelper append(UUID aValue) throws IOException {
        CUtilUuid.toStream(this.mDos, aValue);
        return this;
    }

    public byte[] getByteArray() throws IOException {
        this.mDos.flush();
        this.mDos.close();
        return this.mBaos.toByteArray();
    }

    public DataOutput getStream() {
        return this.mDos;
    }
}

