/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.log.ELevel;
import java.time.LocalDateTime;
import java.util.Properties;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLogDto {
    @NotNull
    private final ELevel mLevel;
    private final int mIndex;
    private final Class<?> mClass;
    private final String mName;
    private Supplier<?> mSupplier;
    private String mMessage = "";
    private Properties mProperties;
    private Object[] mArguments;
    private Throwable mThrowable;
    private String mFileWhereLogged;
    private String mClassWhereLogged;
    private String mMethodWhereLogged;
    private int mLineWhereLogged;
    private String mThreadName;
    private LocalDateTime mTimeStamp;
    private boolean mIsNativeMethod;
    private int mThreadPriority;
    private String mFormattedText = "";

    public CLogDto(@NotNull ELevel aLevel, int aIndex, @Nullable Class<?> aClass, @Nullable String aName) {
        this.mLevel = aLevel;
        this.mIndex = aIndex;
        this.mClass = aClass;
        this.mName = aName;
        this.mTimeStamp = LocalDateTime.now();
    }

    @Nullable
    public Object[] getArguments() {
        return this.mArguments;
    }

    @Nullable
    public String getClassWhereLogged() {
        return this.mClassWhereLogged;
    }

    @Nullable
    public String getFileWhereLogged() {
        return this.mFileWhereLogged;
    }

    @NotNull
    public String getFormattedText() {
        return this.mFormattedText;
    }

    @NotNull
    public ELevel getLevel() {
        return this.mLevel;
    }

    public int getLineWhereLogged() {
        return this.mLineWhereLogged;
    }

    @Nullable
    public Class<?> getLoggerClass() {
        return this.mClass;
    }

    @NotNull
    public String getLoggerName() {
        if (this.mClass != null) {
            return this.mClass.getName();
        }
        if (this.mName != null) {
            return this.mName;
        }
        return "";
    }

    @NotNull
    public String getMessage() {
        return this.mMessage;
    }

    public String getMethodWhereLogged() {
        return this.mMethodWhereLogged;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Properties getProperties() {
        return this.mProperties;
    }

    @Nullable
    public Supplier<?> getSupplier() {
        return this.mSupplier;
    }

    @Nullable
    public String getThreadName() {
        return this.mThreadName;
    }

    public int getThreadPriority() {
        return this.mThreadPriority;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.mThrowable;
    }

    @NotNull
    public LocalDateTime getTimeStamp() {
        return this.mTimeStamp;
    }

    public boolean isNativeMethod() {
        return this.mIsNativeMethod;
    }

    public void setArguments(@Nullable Object[] aArguments) {
        this.mArguments = aArguments;
    }

    public void setClassWhereLogged(@Nullable String aClassWhereLogged) {
        this.mClassWhereLogged = aClassWhereLogged;
    }

    public void setFileWhereLogged(@Nullable String aFileWhereLogged) {
        this.mFileWhereLogged = aFileWhereLogged;
    }

    public void setFormattedText(@NotNull String aFormattedText) {
        this.mFormattedText = aFormattedText;
    }

    public void setLineWhereLogged(int aLineWhereLogged) {
        this.mLineWhereLogged = aLineWhereLogged;
    }

    public void setMessage(@NotNull String aMessage) {
        this.mMessage = aMessage;
    }

    public void setMethodWhereLogged(String aMethodWhereLogged) {
        this.mMethodWhereLogged = aMethodWhereLogged;
    }

    public void setNativeMethod(boolean aNativeMethod) {
        this.mIsNativeMethod = aNativeMethod;
    }

    public void setProperties(@Nullable Properties aProperties) {
        this.mProperties = aProperties;
    }

    public void setSupplier(@Nullable Supplier<?> aSupplier) {
        this.mSupplier = aSupplier;
    }

    public void setThreadName(@Nullable String aThreadName) {
        this.mThreadName = aThreadName;
    }

    public void setThreadPriority(int aThreadPriority) {
        this.mThreadPriority = aThreadPriority;
    }

    public void setThrowable(@Nullable Throwable aThrowable) {
        this.mThrowable = aThrowable;
    }

    public void setTimeStamp(@NotNull LocalDateTime aTimeStamp) {
        this.mTimeStamp = aTimeStamp;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mLevel);
        if (!this.mMessage.isEmpty()) {
            sb.append(" ").append(this.mMessage);
        }
        if (this.mProperties != null) {
            sb.append(" ").append(this.mProperties);
        }
        return sb.toString();
    }
}

