/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObject;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotString
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final String mValue;

    CSlotString() {
        this.mValue = "";
    }

    private CSlotString(@Nullable String aValue) {
        this.mValue = aValue == null ? "" : aValue;
    }

    @NotNull
    private static CSlotString fromObject(@Nullable Object aValue) {
        if (aValue instanceof String) {
            return CSlotString.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotString.fromList((List)aValue);
        }
        return new CSlotString();
    }

    @NotNull
    private static CSlotString fromList(@NotNull List<?> aValue) {
        CSlotString result;
        if (aValue.isEmpty()) {
            result = new CSlotString();
        } else {
            Object value = aValue.get(0);
            result = CSlotString.fromObject(value);
        }
        return result;
    }

    @NotNull
    private static CSlotString fromStream(@NotNull DataInput aStream) throws IOException {
        String value = CUtilString.fromStream(aStream);
        return new CSlotString(value);
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotString fromString(@NotNull String aValue) {
        return new CSlotString(aValue);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotString.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        String value = CUtilString.fromObject(aValue, "");
        return new CSlotString(value);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotString other = (CSlotString)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return String.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.STRING;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotString.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilString.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObject.toString(this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

