/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotLong
implements ISlot,
ISingleSlotTypeFactory {
    private final long mValue;

    CSlotLong() {
        this.mValue = 0L;
    }

    private CSlotLong(long aValue) {
        this.mValue = aValue;
    }

    private CSlotLong(Long aValue) {
        this.mValue = aValue == null ? 0L : aValue;
    }

    @NotNull
    private static CSlotLong fromObject(@Nullable Object aValue) {
        if (aValue instanceof Long) {
            return new CSlotLong((Long)aValue);
        }
        if (aValue instanceof String) {
            return CSlotLong.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotLong.fromList((List)aValue);
        }
        return new CSlotLong();
    }

    @NotNull
    private static CSlotLong fromList(@NotNull List<?> aValue) {
        CSlotLong result;
        if (aValue.isEmpty()) {
            result = new CSlotLong();
        } else {
            Object object = aValue.get(0);
            result = CSlotLong.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotLong fromStream(@NotNull DataInput aStream) throws IOException {
        long value = aStream.readLong();
        return new CSlotLong(value);
    }

    @NotNull
    private static CSlotLong fromString(@NotNull String aValue) {
        long value = CUtilLong.fromString(aValue);
        return new CSlotLong(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotLong.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        long value = CUtilLong.fromObject(aValue, 0L);
        return new CSlotLong(value);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Long.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CSlotLong cSlotLong = (CSlotLong)aOther;
        return this.mValue == cSlotLong.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.LONG;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Long.valueOf(this.mValue).equals(aValue);
    }

    public boolean isEqual(long aValue) {
        return this.mValue == aValue;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotLong.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeLong(this.mValue);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public String toString() {
        return Long.toString(this.mValue);
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public String valueToString() {
        return Long.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

