/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.hook.target;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.hook.IPrivateMessageHookRegistry;
import de.sillysky.nyssr.message.hook.records.CRecordNotifyMessageHooked;
import de.sillysky.nyssr.message.hook.records.CRecordServiceDeregisterMessageLogger;
import de.sillysky.nyssr.message.hook.records.CRecordServiceRegisterMessageLogger;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.notification.records.CRecordNotifyNamespaceDeregistered;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

final class CTargetForMessageHookRegistry
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForMessageHookRegistry.class);
    private IPrivateMessageHookRegistry mRegistry;
    private INameDb mNameDb;
    private IRecordHelper mRecordHelper;

    CTargetForMessageHookRegistry() {
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IPrivateMessageHookRegistry.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNameDb = aServiceRegistry.getService(INameDb.class);
        this.mRegistry = aServiceRegistry.getService(IPrivateMessageHookRegistry.class);
        this.mRecordHelper = aServiceRegistry.getService(IRecordHelper.class);
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordServiceRegisterMessageLogger.ID, this::asyncRegisterMessageLogger);
        this.addMessageHandler(CRecordServiceDeregisterMessageLogger.ID, this::asyncDeregisterMessageLogger);
        this.addMessageHandler(CRecordNotifyMessageHooked.ID, this::asyncNotifyMessageHooked);
        this.addMessageHandler(CRecordNotifyNamespaceDeregistered.ID, this::asyncNotifyNamespaceDeregistered);
        this.addMessageHandler(CRecordNotifyTargetDeregistered.ID, this::asyncNotifyTargetDeregistered);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        ITargetRegistry tr = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget(this, CWellKnownTID.MSG_HOOK_REGISTRY);
    }

    private boolean asyncDeregisterMessageLogger(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress observer = CRecordServiceDeregisterMessageLogger.getObserver(aRecord, null);
        if (observer == null || !observer.isValid()) {
            aEnvelope.setResult(2304, "Observer invalid.");
        } else {
            this.mRegistry.removeObserver(observer);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncNotifyMessageHooked(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                CTargetAddress address = aEnvelope.getSender();
                this.mRegistry.removeObserver(address);
            }
            return true;
        }
        return false;
    }

    private boolean asyncNotifyNamespaceDeregistered(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        IId nid = CRecordNotifyNamespaceDeregistered.getNamespace(aRecord, null);
        this.mRegistry.notifyNamespaceDeregistered(nid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode(aRecord, null);
        this.mRegistry.notifyRemoteNodeRemoved(node);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyTargetDeregistered(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress address = CRecordNotifyTargetDeregistered.getAddress(aRecord, null);
        this.mRegistry.notifyTargetDeregistered(address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterMessageLogger(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress observer = CRecordServiceRegisterMessageLogger.getObserver(aRecord, null);
        if (observer == null || !observer.isValid()) {
            aEnvelope.setResult(2304, "Observer invalid.");
        } else {
            CTargetAddress[] receiverFilter = CRecordServiceRegisterMessageLogger.getReceiverFilter(aRecord, null);
            if (receiverFilter == null || receiverFilter.length == 0) {
                this.mRegistry.removeObserver(observer);
            } else {
                this.mRegistry.addObserver(observer, receiverFilter);
            }
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mRegistry.initialize(this.getMessageSender());
        CTargetAddress address = this.getAddress();
        this.mNameDb.getTargetAddressDatabase().putName(address, "MsgHookRegistry");
        this.mRecordHelper.addObserver(CRecordServiceRegisterMessageLogger.class, this, false);
        this.mRecordHelper.addObserver(CRecordServiceDeregisterMessageLogger.class, this, false);
        this.mRecordHelper.addObserver(CRecordNotifyNamespaceDeregistered.class, this, false);
        this.mRecordHelper.addObserver(CRecordNotifyTargetDeregistered.class, this, false);
        this.mRecordHelper.addObserver(CRecordNotifyRemoteNodeRemoved.class, this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

